<?php



// Icon picker
$icons_params = vc_map_integrate_shortcode( 'tm-icon', 'i_', '',
	array(
		'include_only_regex' => '/^(type|icon_\w*)/',
		// we need only type, icon_fontawesome, icon_blabla..., NOT color and etc
	), array(
		'element' => 'add_icon',
		'value' => 'true',
	)
);

// each progress bar options
$param_group = array(
	array(
		'type' => 'textfield',
		'heading' => esc_attr__( 'Label', 'anomica' ),
		'param_name' => 'label',
		'description' => esc_attr__( 'Enter text used as title of bar.', 'anomica' ),
		'admin_label' => true,
	),
	array(
		'type' => 'textfield',
		'heading' => esc_attr__( 'Value', 'anomica' ),
		'param_name' => 'value',
		'description' => esc_attr__( 'Enter value of bar.', 'anomica' ),
		'admin_label' => true,
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_attr__( 'Color', 'anomica' ),
		'param_name' => 'color',
		'value' => array(
				esc_attr__( 'Default', 'anomica' ) => '',
			) + array(
				esc_attr__( 'Classic Grey', 'anomica' ) => 'bar_grey',
				esc_attr__( 'Classic Blue', 'anomica' ) => 'bar_blue',
				esc_attr__( 'Classic Turquoise', 'anomica' ) => 'bar_turquoise',
				esc_attr__( 'Classic Green', 'anomica' ) => 'bar_green',
				esc_attr__( 'Classic Orange', 'anomica' ) => 'bar_orange',
				esc_attr__( 'Classic Red', 'anomica' ) => 'bar_red',
				esc_attr__( 'Classic Black', 'anomica' ) => 'bar_black',
			) + themetechmount_getVcShared( 'colors-dashed' ) /*+ array(
				esc_attr__( 'Custom Color', 'anomica' ) => 'custom',
			)*/,
		'description' => esc_attr__( 'Select single bar background color.', 'anomica' ),
		'admin_label' => true,
		'param_holder_class' => 'vc_colored-dropdown',
	),
	
	// Show / Hide icon
	array(
		'type'       => 'dropdown',
		'heading'    => esc_attr__( 'Show Icon?', 'anomica' ),
		'param_name' => 'add_icon',
		'value'      => array(
			esc_attr__( 'Yes', 'anomica' ) => 'true',
			esc_attr__( 'No', 'anomica' )  => 'false',
		),
		'std'         => 'true',
		'description' => esc_attr__( 'Want to show icon with the progress bar.', 'anomica' ),
	)
);



// Merging icon with other options
$param_group = array_merge( $param_group, $icons_params );






$params =  array(
	array(
		'type' => 'textfield',
		'heading' => esc_attr__( 'Widget title', 'anomica' ),
		'param_name' => 'title',
		'description' => esc_attr__( 'Enter text used as widget title (Note: located above content element).', 'anomica' ),
	),
	array(
		'type' => 'param_group',
		'heading' => esc_attr__( 'Values', 'anomica' ),
		'param_name' => 'values',
		'description' => esc_attr__( 'Enter values for graph - value, title and color.', 'anomica' ),
		'value' => urlencode( json_encode( array(
			array(
				'label' => esc_attr__( 'Development', 'anomica' ),
				'value' => '90',
			),
			array(
				'label' => esc_attr__( 'Design', 'anomica' ),
				'value' => '80',
			),
			array(
				'label' => esc_attr__( 'Marketing', 'anomica' ),
				'value' => '70',
			),
		) ) ),
		'params' => $param_group,
	),
	array(
		'type' => 'textfield',
		'heading' => esc_attr__( 'Units', 'anomica' ),
		'param_name' => 'units',
		'description' => esc_attr__( 'Enter measurement units (Example: %, px, points, etc. Note: graph value and units will be appended to graph title).', 'anomica' ),
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_attr__( 'Color', 'anomica' ),
		'param_name' => 'bgcolor',
		'std' => 'skincolor',
		'value' => array(
				esc_attr__( 'Classic Grey', 'anomica' ) => 'bar_grey',
				esc_attr__( 'Classic Blue', 'anomica' ) => 'bar_blue',
				esc_attr__( 'Classic Turquoise', 'anomica' ) => 'bar_turquoise',
				esc_attr__( 'Classic Green', 'anomica' ) => 'bar_green',
				esc_attr__( 'Classic Orange', 'anomica' ) => 'bar_orange',
				esc_attr__( 'Classic Red', 'anomica' ) => 'bar_red',
				esc_attr__( 'Classic Black', 'anomica' ) => 'bar_black',
			) + themetechmount_getVcShared( 'colors-dashed' ) /* + array(
				esc_attr__( 'Custom Color', 'anomica' ) => 'custom',
			)*/ ,
		'description' => esc_attr__( 'Select bar background color.', 'anomica' ),
		'admin_label' => true,
		'param_holder_class' => 'vc_colored-dropdown',
	),
	array(
		'type' => 'checkbox',
		'heading' => esc_attr__( 'Options', 'anomica' ),
		'param_name' => 'options',
		'value' => array(
			esc_attr__( 'Add stripes', 'anomica' ) => 'striped',
			esc_attr__( 'Add animation (Note: visible only with striped bar).', 'anomica' ) => 'animated',
		),
	),
);



$params = array_merge(
	$params,
	array( vc_map_add_css_animation() ),
	array( themetechmount_vc_ele_extra_class_option() ),
	array( themetechmount_vc_ele_css_editor_option() )
);
		


global $tm_sc_params_progressbar;
$tm_sc_params_progressbar = $params;


vc_map( array(
	'name'		=> esc_attr__( 'ThemetechMount Progress Bar', 'anomica' ),
	'base'		=> 'tm-progress-bar',
	'class'		=> '',
	'icon'		=> 'icon-themetechmount-vc',
	'category'	=> esc_attr__( 'ThemetechMount Special Elements', 'anomica' ),
	'params'	=> $params
) );
