<?php

/* Options for ThemetechMount Blogbox */


$portfolioCatList = array();
if( taxonomy_exists('tm_portfolio_category') ){
	$portfolioCatList_data = get_terms( 'tm_portfolio_category', array( 'hide_empty' => false ) );
	$portfolioCatList      = array();
	foreach($portfolioCatList_data as $cat){
		$portfolioCatList[ esc_attr($cat->name) . ' (' . esc_attr($cat->count) . ')' ] = esc_attr($cat->slug);
	}
}


// Getting Options
$anomica_theme_options   = get_option('anomica_theme_options');
$pf_type_title          = ( !empty($anomica_theme_options['pf_type_title']) ) ? $anomica_theme_options['pf_type_title'] : 'Portfolio' ;
$pf_type_title_singular = ( !empty($anomica_theme_options['pf_type_title_singular']) ) ? $anomica_theme_options['pf_type_title_singular'] : 'Portfolio' ;
$pf_cat_title           = ( !empty($anomica_theme_options['pf_cat_title']) ) ? $anomica_theme_options['pf_cat_title'] : 'Portfolio Categories' ;
$pf_cat_title_singular  = ( !empty($anomica_theme_options['pf_cat_title_singular']) ) ? $anomica_theme_options['pf_cat_title_singular'] : 'Portfolio Category' ;


/**
 * Heading Element
 */
$heading_element = vc_map_integrate_shortcode( 'tm-heading', '', '',
	array(
		'exclude' => array(
			'el_class',
			'css',
			'css_animation'
		),
	)
);

/**
 * Box Design options
 */
$boxParams = themetechmount_box_params();


$allParams = array_merge(
		
		$heading_element,
		array( 
			array(
				"type"        => "themetechmount_style_selector",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Box Design",'anomica'),
				"description" => esc_attr__("Select box design.",'anomica'),
				"param_name"  => "view",
				"value"       => themetechmount_global_portfolio_template_list( true ),
				"std"         => "portfolio-style-one",
				'group'		  => esc_attr__( 'Box Style', 'anomica' ),
			),
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Show",'anomica'),
				"description" => sprintf( esc_attr__("How many %s item you want to show.", "anomica"), $pf_type_title ),
				"param_name"  => "show",
				"value"       => array(
					esc_attr__("All", "anomica") => "-1",
					esc_attr__('1', "anomica")   => "1",
					esc_attr__('2', "anomica")   => "2",
					esc_attr__('3','anomica')    =>'3',
					esc_attr__('4','anomica')    =>'4',
					esc_attr__('5','anomica')    =>'5',
					esc_attr__('6','anomica')    =>'6',
					esc_attr__('7','anomica')    =>'7',
					esc_attr__('8','anomica')    =>'8',
					esc_attr__('9','anomica')    =>'9',
					esc_attr__('10','anomica')   =>'10',
					esc_attr__('11','anomica')   =>'11',
					esc_attr__('12','anomica')   =>'12',
					esc_attr__('13','anomica')   =>'13',
					esc_attr__('14','anomica')   =>'14',
					esc_attr__('15','anomica')   =>'15',
					esc_attr__('16','anomica')   =>'16',
					esc_attr__('17','anomica')   =>'17',
					esc_attr__('18','anomica')   =>'18',
					esc_attr__('19','anomica')   =>'19',
					esc_attr__('20','anomica')   =>'20',
					esc_attr__('21','anomica')   =>'21',
					esc_attr__('22','anomica')   =>'22',
					esc_attr__('23','anomica')   =>'23',
					esc_attr__('24','anomica')   =>'24',
				),
				"std"  => "3",
				'group'		  => esc_attr__( 'Box Style', 'anomica' ),
			),
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Show Sortable Category Links",'anomica'),
				"description" => sprintf( esc_attr__("Show sortable category links above %s items so user can sort by just single click.",'anomica'), $pf_type_title_singular ),
				"param_name"  => "sortable",
				"value"       => array(
					esc_attr__('No','anomica')  => 'no',
					esc_attr__('Yes','anomica') => 'yes',
				),
				"std"         => "no",
				'dependency'  => array(
					'element'            => 'boxview',
					'value_not_equal_to' => array( 'carousel' ),
				),
				'group'		  => esc_attr__( 'Box Style', 'anomica' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_attr__( 'Replace ALL word', 'anomica' ),
				'param_name'  => 'allword',
				'description' => esc_attr__( 'Replace ALL word in sortable category links. Default is ALL word.', 'anomica' ),
				"std"         => "All",
				'dependency'  => array(
					'element'   => 'sortable',
					'value'     => array( 'yes' ),
				),
				'group'		  => esc_attr__( 'Box Style', 'anomica' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_attr__( 'Sortable Button Type', 'anomica' ),
				'description' => esc_attr__( 'Sortable Button type square or round', 'anomica' ),
				'param_name'  => 'sortable_buttontype',
				"value"       => array(
					esc_attr__('Square','anomica')  => 'square',
					esc_attr__('Round','anomica') => 'round',
				),
				"std"         => "square",
				'dependency'  => array(
					'element'   => 'sortable',
					'value'     => array( 'yes' ),
				),
				'group'		  => esc_attr__( 'Box Style', 'anomica' ),
			),
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Show Pagination",'anomica'),
				"description" => sprintf( esc_attr__("Show pagination links below %s boxes.",'anomica'), $pf_type_title ),
				"param_name"  => "pagination",
				"value"       => array(
					esc_attr__('No','anomica')  => 'no',
					esc_attr__('Yes','anomica') => 'yes',
				),
				"std"         => "no",
				'dependency'  => array(
					'element'    => 'sortable',
					'value_not_equal_to' => array( 'yes' ),
				),
				'group'		  => esc_attr__( 'Box Style', 'anomica' ),
			),
			array(
				"type"        => "checkbox",
				"heading"     => sprintf( esc_attr__("From %s", "anomica"), $pf_cat_title_singular ),
				"description" => sprintf( esc_attr__('If you like to show %1$s from selected %2$s than select the category here.', "anomica"), $pf_type_title, $pf_cat_title ),
				
				"param_name"  => "category",
				"value"       => $portfolioCatList,
				'group'		  => esc_attr__( 'Box Style', 'anomica' ),
			),
			
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Order by",'anomica'),
				"description" => esc_attr__("Sort retrieved portfolio by parameter.",'anomica'),
				"param_name"  => "orderby",
				"value"       => array(
					esc_attr__('No order (none)','anomica')           => 'none',
					esc_attr__('Order by post id (ID)','anomica')     => 'ID',
					esc_attr__('Order by author (author)','anomica')  => 'author',
					esc_attr__('Order by title (title)','anomica')    => 'title',
					esc_attr__('Order by slug (name)','anomica')      => 'name',
					esc_attr__('Order by date (date)','anomica')      => 'date',
					esc_attr__('Order by last modified date (modified)','anomica') => 'modified',
					esc_attr__('Random order (rand)','anomica')       => 'rand',
					esc_attr__('Order by number of comments (comment_count)','anomica') => 'comment_count',
					
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				"std"              => "date",
				'group'		  	   => esc_attr__( 'Box Style', 'anomica' ),
			),
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Order",'anomica'),
				"description" => esc_attr__("Designates the ascending or descending order of the 'orderby' parameter.",'anomica'),
				"param_name"  => "order",
				"value"       => array(
					esc_attr__('Ascending (1, 2, 3; a, b, c)','anomica')  => 'ASC',
					esc_attr__('Descending (3, 2, 1; c, b, a)','anomica') => 'DESC',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				"std"              => "DESC",
				'group'			   => esc_attr__( 'Box Style', 'anomica' ),
			),
			array(
				"type"        => "dropdown",
				"heading"     => esc_attr__("Box Spacing", "anomica"),
				"param_name"  => "box_spacing",
				"description" => esc_attr__("Spacing between each box.", "anomica"),
				"value"       => array(
					esc_attr__("Default", "anomica")                        => "",
					esc_attr__("0 pixel spacing (joint boxes)", "anomica")  => "0px",
					esc_attr__("5 pixel spacing", "anomica")                => "5px",
					esc_attr__("10 pixel spacing", "anomica")               => "10px",
				),
				"std"  		  => "10px",
				'group'		  => esc_attr__( 'Box Style', 'anomica' ),
			)
		),
		$boxParams,
		array(
			themetechmount_vc_ele_css_editor_option(),
		)
		
	);



$params = $allParams;


// Changing default values
$i = 0;
foreach( $params as $param ){
	$param_name = (isset($param['param_name'])) ? $param['param_name'] : '' ;
	if( $param_name == 'h2' ){
		$params[$i]['std'] = 'Our Work';
		
	} else if( $param_name == 'h2_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'h4_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'txt_align' ){
		$params[$i]['std'] = 'center';
	}
	$i++;
}



global $tm_sc_params_portfoliobox;
$tm_sc_params_portfoliobox = $params;




vc_map( array(
	"name"     => sprintf( esc_attr__("ThemetechMount %s Box",'anomica'), $pf_type_title_singular ),
	"base"     => "tm-portfoliobox",
	"class"    => "",
	'category' => esc_attr__( 'ThemetechMount Special Elements', 'anomica' ),
	"icon"     => "icon-themetechmount-vc",
	"params"   => $params,
) );