<?php

/* Options for ThemetechMount Icon */


/*
 * Icon Element
 * @since 4.4
 */


/**
 *  Show selected icon library only
 */
global $anomica_theme_options;

// Temporary new list of icon libraries
$icon_library_array = array( // all icon library list array
	'themify'        => array( esc_attr__( 'Themify icons', 'anomica' ),   'themifyicon ti-thumb-up'),
	'linecons'       => array( esc_attr__( 'Linecons', 'anomica' ), 'vc_li vc_li-star'),
	'kw_anomica'   => array( esc_attr__( 'Special Icons', 'anomica' ), 'flaticon-honey'),
);


$icon_library = array();
if( isset($anomica_theme_options['icon_library']) && is_array($anomica_theme_options['icon_library']) && count($anomica_theme_options['icon_library'])>0 ){
	// if selected icon library
	foreach( $anomica_theme_options['icon_library'] as $i_library ){
		$icon_library[$i_library] = $icon_library_array[$i_library];
	}
}



$icon_element_array  = array();
$icon_dropdown_array = array( esc_attr__( 'Font Awesome', 'anomica' )    => 'fontawesome' );   // Font Awesome icons
$icon_dropdown_array[ esc_attr__( 'Special Icons', 'anomica' ) ] = 'kw_anomica'; // Special icons

if( is_array($icon_library) && count($icon_library)>0 ){
foreach( $icon_library as $library_id=>$library ){
	
	$icon_dropdown_array[$library[0]] = $library_id;
	
	$icon_element_array[]  = array(
		'type'        => 'themetechmount_iconpicker',
		'heading'     => esc_attr__( 'Icon', 'anomica' ),
		'param_name'  => 'icon_'.$library_id,
		'value'       => $library[1], // default value to backend editor admin_label
		'settings'    => array(
			'emptyIcon'    => false, // default true, display an "EMPTY" icon?
			'type'         => $library_id,
		),
		'dependency'  => array(
			'element'   => 'type',
			'value'     => $library_id,
		),
		'description' => esc_attr__( 'Select icon from library.', 'anomica' ),
		'edit_field_class' => 'vc_col-sm-9 vc_column',
	);
	
	
}
}
/* Select icon library code end here */




// All icon related elements
$icon_elements = array_merge(
	array(
		array(
			'type'        => 'dropdown',
			'heading'     => esc_attr__( 'Icon library', 'anomica' ),
			'value'       => $icon_dropdown_array,
			'std'         => '',
			'admin_label' => true,
			'param_name'  => 'type',
			'description' => esc_attr__( 'Select icon library.', 'anomica' ),
			'edit_field_class' => 'vc_col-sm-3 vc_column',
		)
	),
	array(
		array(  // Font Awesome icons
			'type'       => 'themetechmount_iconpicker',
			'heading'    => esc_attr__( 'Icon', 'anomica' ),
			'param_name' => 'icon_fontawesome',
			'value'      => 'fa fa-thumbs-o-up', // default value to backend editor admin_label
			'settings'   => array(
				'emptyIcon'    => false, // default true, display an "EMPTY" icon?
				'type'         => 'fontawesome',
			),
			'dependency' => array(
				'element'  => 'type',
				'value'    => 'fontawesome',
			),
			'description' => esc_attr__( 'Select icon from library.', 'anomica' ),
			'edit_field_class' => 'vc_col-sm-9 vc_column',
		),
	),
	
	array(
		array(  // Anomica special icons
			'type'       => 'themetechmount_iconpicker',
			'heading'    => esc_attr__( 'Icon', 'anomica' ),
			'param_name' => 'icon_kw_anomica',
			'value'      => 'flaticon-honey', // default value to backend editor admin_label
			'settings'   => array(
				'emptyIcon'    => false, // default true, display an "EMPTY" icon?
				'type'         => 'kw_anomica',
			),
			'dependency' => array(
				'element'  => 'type',
				'value'    => 'kw_anomica',
			),
			'description' => esc_attr__( 'Select icon from library.', 'anomica' ),
			'edit_field_class' => 'vc_col-sm-9 vc_column',
		)
	),
	
	$icon_element_array
	
	
);


$allparams = array(
	array(
		'type'        => 'dropdown',
		'heading'     => esc_attr__( 'Icon color', 'anomica' ),
		'param_name'  => 'color',
		'value'       => array_merge( 
			themetechmount_getVcShared( 'colors' ),
			array(
				esc_attr__( 'Classic Grey', 'anomica' )      => 'bar_grey',
				esc_attr__( 'Classic Blue', 'anomica' )      => 'bar_blue',
				esc_attr__( 'Classic Turquoise', 'anomica' ) => 'bar_turquoise',
				esc_attr__( 'Classic Green', 'anomica' )     => 'bar_green',
				esc_attr__( 'Classic Orange', 'anomica' )    => 'bar_orange',
				esc_attr__( 'Classic Red', 'anomica' )       => 'bar_red',
				esc_attr__( 'Classic Black', 'anomica' )     => 'bar_black',
			),
			array( esc_attr__( 'Custom color', 'anomica' ) => 'custom' )
		),
		'std'         => 'skincolor',
		'description' => esc_attr__( 'Select icon color.', 'anomica' ),
		'param_holder_class' => 'tm_vc_colored-dropdown',
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_attr__( 'Custom color', 'anomica' ),
		'param_name'  => 'custom_color',
		'description' => esc_attr__( 'Select custom icon color.', 'anomica' ),
		'dependency'  => array(
			'element'   => 'color',
			'value'     => 'custom',
		),
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_attr__( 'Background shape', 'anomica' ),
		'param_name'  => 'background_style',
		'value'       => array(
			esc_attr__( 'None', 'anomica' ) => '',
			esc_attr__( 'Circle', 'anomica' ) => 'rounded',
			esc_attr__( 'Square', 'anomica' ) => 'boxed',
			esc_attr__( 'Rounded', 'anomica' ) => 'rounded-less',
			esc_attr__( 'Outline Circle', 'anomica' ) => 'rounded-outline',
			esc_attr__( 'Outline Square', 'anomica' ) => 'boxed-outline',
			esc_attr__( 'Outline Rounded', 'anomica' ) => 'rounded-less-outline',
		),
		'std'         => '',
		'description' => esc_attr__( 'Select background shape and style for icon.', 'anomica' ),
		'param_holder_class' => 'tm-simplify-textarea',
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_attr__( 'Background color', 'anomica' ),
		'param_name'  => 'background_color',
		'value'       => array_merge( array( esc_attr__( 'Transparent', 'anomica' ) => 'transparent' ), themetechmount_getVcShared( 'colors' ), array( esc_attr__( 'Custom color', 'anomica' ) => 'custom' ) ),
		'std'         => 'grey',
		'description' => esc_attr__( 'Select background color for icon.', 'anomica' ),
		'param_holder_class' => 'tm_vc_colored-dropdown',
		'dependency'  => array(
			'element'   => 'background_style',
			'not_empty' => true,
		),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_attr__( 'Custom background color', 'anomica' ),
		'param_name'  => 'custom_background_color',
		'description' => esc_attr__( 'Select custom icon background color.', 'anomica' ),
		'dependency'  => array(
			'element'   => 'background_color',
			'value'     => 'custom',
		),
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_attr__( 'Size', 'anomica' ),
		'param_name'  => 'size',
		'value'       => array_merge( themetechmount_getVcShared( 'sizes' ), array( 'Extra Large' => 'xl' ) ),
		'std'         => 'md',
		'description' => esc_attr__( 'Icon size.', 'anomica' )
	),
	array(
		'type'       => 'dropdown',
		'heading'    => esc_attr__( 'Icon alignment', 'anomica' ),
		'param_name' => 'align',
		'value'      => array(
			esc_attr__( 'Left', 'anomica' )   => 'left',
			esc_attr__( 'Right', 'anomica' )  => 'right',
			esc_attr__( 'Center', 'anomica' ) => 'center',
		),
		'std'         => 'left',
		'description' => esc_attr__( 'Select icon alignment.', 'anomica' ),
	),
	array(
		'type'        => 'vc_link',
		'heading'     => esc_attr__( 'URL (Link)', 'anomica' ),
		'param_name'  => 'link',
		'description' => esc_attr__( 'Add link to icon.', 'anomica' )
	),
	vc_map_add_css_animation(),
	themetechmount_vc_ele_extra_class_option(),
	themetechmount_vc_ele_css_editor_option(),
);


// All params
$params = array_merge( $icon_elements, $allparams );

	
	
global $tm_sc_params_icon;
$tm_sc_params_icon = $params;

	
	

vc_map( array(
	'name'     => esc_attr__( 'ThemetechMount Icon', 'anomica' ),
	'base'     => 'tm-icon',
	'icon'     => 'icon-themetechmount-vc',
	'category' => array( esc_attr__( 'ThemetechMount Special Elements', 'anomica' ) ),
	'admin_enqueue_css' => array(get_template_directory_uri().'/assets/themify-icons/themify-icons.css', get_template_directory_uri().'/assets/twemoji-awesome/twemoji-awesome.css' ),
	'params'   => $params,
	'js_view'  => 'VcIconElementView_Backend',
) );
