<?php

/* Options */

$allParams = array(
	array(
		"type"        => "dropdown",
		"holder"      => "div",
		"class"       => "",
		"heading"     => esc_attr__("Show Pagination",'anomica'),
		"description" => esc_attr__("Show pagination links below Event boxes.",'anomica'),
		"param_name"  => "pagination",
		"value"       => array(
			esc_attr__('No','anomica')  => 'no',
			esc_attr__('Yes','anomica') => 'yes',
		),
		"std"         => "no",
		'dependency'  => array(
			'element'    => 'sortable',
			'value_not_equal_to' => array( 'yes' ),
		),
	),
	array(
		"type"        => "dropdown",
		"holder"      => "div",
		"class"       => "",
		"heading"     => esc_attr__("Show Events Item",'anomica'),
		"description" => esc_attr__("How many events you want to show.",'anomica'),
		"param_name"  => "show",
		"value"       => array(
			esc_attr__('All','anomica') => '-1',
			esc_attr__('1','anomica')  => '1',
			esc_attr__('2','anomica') => '2',
			esc_attr__('3','anomica')=>'3',
			esc_attr__('4','anomica')=>'4',
			esc_attr__('5','anomica')=>'5',
			esc_attr__('6','anomica')=>'6',
			esc_attr__('7','anomica')=>'7',
			esc_attr__('8','anomica')=>'8',
			esc_attr__('9','anomica')=>'9',
			esc_attr__('10','anomica')=>'10',
			esc_attr__('11','anomica')=>'11',
			esc_attr__('12','anomica')=>'12',
			esc_attr__('13','anomica')=>'13',
			esc_attr__('14','anomica')=>'14',
			esc_attr__('15','anomica')=>'15',
			esc_attr__('16','anomica')=>'16',
			esc_attr__('17','anomica')=>'17',
			esc_attr__('18','anomica')=>'18',
			esc_attr__('19','anomica')=>'19',
			esc_attr__('20','anomica')=>'20',
			esc_attr__('21','anomica')=>'21',
			esc_attr__('22','anomica')=>'22',
			esc_attr__('23','anomica')=>'23',
			esc_attr__('24','anomica')=>'24',
		),
		"std"  => "3",
	),
	array(
		"type"        => "dropdown",
		"heading"     => esc_attr__("Box Style", "anomica"),
		"description" => esc_attr__("Select box style.", "anomica"),
		"group"       => esc_attr__( "Box Design", "anomica" ),
		"param_name"  => "view",
		"value"       => array(
			esc_attr__("Default Style", "anomica")  => "top-image",
			esc_attr__("Detailed Style", "anomica") => "top-image-details",
		),
		"std"         => "default",
	),
	array(
		"type"        => "dropdown",
		"heading"     => esc_attr__("Box Spacing", "anomica"),
		"param_name"  => "box_spacing",
		"description" => esc_attr__("Spacing between each box.", "anomica"),
		"value"       => array(
			esc_attr__("Default", "anomica")                        => "",
			esc_attr__("0 pixel spacing (joint boxes)", "anomica")  => "0px",
			esc_attr__("5 pixel spacing", "anomica")                => "5px",
			esc_attr__("10 pixel spacing", "anomica")               => "10px",
		),
		"std"  => "",
	),
	
);


/**
 * Heading Element
 */
$heading_element = vc_map_integrate_shortcode( 'tm-heading', '', '',
	array(
		'exclude' => array(
			'el_class',
			'css',
			'css_animation'
		),
	)
);

$boxParams = themetechmount_box_params();
$params    = array_merge( $heading_element, $allParams, $boxParams );


// Changing default values
$i = 0;
foreach( $params as $param ){
	$param_name = (isset($param['param_name'])) ? $param['param_name'] : '' ;
	if( $param_name == 'h2' ){
		$params[$i]['std'] = 'Latest Events';
		
	} else if( $param_name == 'h2_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'h4_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	}
	$i++;
}


global $tm_sc_params_eventsbox;
$tm_sc_params_eventsbox = $params;


vc_map( array(
	"name"     => esc_attr__("ThemetechMount Events Box", "anomica"),
	"base"     => "tm-eventsbox",
	"icon"     => "icon-themetechmount-vc",
	'category' => esc_attr__( 'ThemetechMount Special Elements', 'anomica' ),
	"params"   => $params
) );

