<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Client Box
*/

class Anomica_Clientbox_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_client_element';
	}

	public function get_title() {
		return esc_attr__( 'Client Logo Box', 'anomica' );
	}

	public function get_icon() {
		return 'eicon-user-circle-o';
	}

	public function get_categories() {
		return [ 'anomica_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}

	protected function register_controls() {

		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_attr__( 'General', 'anomica' ),
			]
		);
		
		$this->add_control(
			'style',
			[
				'label'			=> esc_attr__( 'Select Client View Style', 'anomica' ),
				'description'	=> esc_attr__( 'Select Client View style.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'options' => [
					'simple-logo'		=> esc_attr( 'Simple Logo view' ),
					'separator-logo'	=> esc_attr( 'Logo with Separator view' ),
					'boxed-logo'		=> esc_attr( 'Boxed view' ),
				],
				'default' => esc_attr( 'simple-logo' ),
			]
		);
		
		$this->add_control(
			'heading',
			[
				'label' => esc_attr__( 'Heading', 'anomica' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( '', 'anomica' ),
				'placeholder' => esc_attr__( 'Enter text for heading text.', 'anomica' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'subheading',
			[
				'label' => esc_attr__( 'Subheading', 'anomica' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( '', 'anomica' ),
				'placeholder' => esc_attr__( 'Enter text for subheading text.', 'anomica' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'reverse_heading',
			[
				'label' => esc_attr__( 'Reverse Heading Order', 'anomica' ),
				'description' => esc_attr__( 'Show sub-heding before heading', 'anomica' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_attr__( 'Yes', 'anomica' ),
				'label_off' => esc_attr__( 'No', 'anomica' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		
		$this->add_control(
			'desc',
			[
				'label' => esc_attr__( 'Description', 'anomica' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_attr__( 'Type your description text', 'anomica' ),
			]
		);
		
		$this->add_control(
			'heading_sep',
			[
				'label' => esc_attr__( 'Seperator', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none'	=> esc_attr( 'None' ),
					'solid'	=> esc_attr( 'Solid' ),
					'style1'	=> esc_attr( 'Style1' ),
				],
				'default' => esc_attr( 'solid' ),
			]
		);
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_attr__( 'Alignment', 'anomica' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_attr__( 'Left', 'anomica' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_attr__( 'Center', 'anomica' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_attr__( 'Right', 'anomica' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'tm-align-',
				'selectors' => [
					'{{WRAPPER}} .tm-heading-subheading' => 'text-align: {{VALUE}};',
				],
				'dynamic' => [
					'active' => true,
				],
				'default' => 'left',
			]
		);
		
		$this->add_control(
			'heading_style',
			[
				'label'			=> esc_attr__( 'Heading Style', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'vertical'	=> esc_attr( 'Vertical (Default)' ),
					'horizontal'	=> esc_attr( 'Horizontal' ),
				],
				'default' => esc_attr( 'vertical' ),
			]
		);

		$this->add_control(
			'tag_options',
			[
				'label'			=> esc_attr__( 'Tags for SEO', 'anomica' ),
				'type'			=> Controls_Manager::HEADING,
				'separator'		=> 'before',
			]
		);
		
		$this->add_control(
			'heading_tag',
			[
				'label' => esc_attr__( 'Heading Tag', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h2' ),
			]
		);
		
		$this->add_control(
			'subheading_tag',
			[
				'label' => esc_attr__( 'Subheading Tag', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h4' ),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Data Design', 'anomica' ),
			]
		);
		
		$this->add_control(
			'from_category',
			[
				'label' => esc_attr__( 'From Category ?', 'anomica' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $this->select_category(),
				'multiple' => true,
				'label_block'	=> true,
				'placeholder' => esc_attr__( 'All Categories', 'anomica' ),
			]
		);
		
		$this->add_control(
			'show',
			[
				'label' => esc_attr__( 'Post to show', 'anomica' ),
				'description' => esc_attr__( 'How many Post you want to show.', 'anomica' ),
				'separator' => 'before',
				'type' => Controls_Manager::NUMBER,
				'default' => '3',
			]
		);
		
		$this->add_control(
			'sortable',
			[
				'label' => esc_attr__( 'Show Sortable Category Links', 'anomica' ),
				'description' => esc_attr__( 'Show sortable category links above items so user can sort by just single click.', 'anomica' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_attr__( 'Yes', 'anomica' ),
				'label_off' => esc_attr__( 'No', 'anomica' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_attr__( 'Order', 'anomica' ),
				'description' => esc_attr__( 'Designates the ascending or descending order.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'separator' => 'before',
				'default' => 'DESC',
				'options' => [
					'ASC'		=> esc_attr__( 'Ascending order (1, 2, 3; a, b, c)', 'anomica' ),
					'DESC'		=> esc_attr__( 'Descending order (3, 2, 1; c, b, a)', 'anomica' ),
				]
			]
		);
		
		$this->add_control(
			'orderby',
			[
				'label' => esc_attr__( 'Order By', 'anomica' ),
				'description' => esc_attr__( ' Sort retrieved posts by parameter.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'none'		=> esc_attr__( 'No order', 'anomica' ),
					'ID'		=> esc_attr__( 'ID', 'anomica' ),
					'title'		=> esc_attr__( 'Title', 'anomica' ),
					'date'		=> esc_attr__( 'Date', 'anomica' ),
					'rand'		=> esc_attr__( 'Random', 'anomica' ),
				]
			]
		);
		
		$this->add_control(
			'gap',
			[
				'label' => esc_attr__( 'Box Gap', 'anomica' ),
				'description' => esc_attr__( 'Gap between each Post box.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'default' => '30px',
				'options' => [
					'0px'		=> esc_attr__( 'No Gap (0px)', 'anomica' ),
					'5px'		=> esc_attr__( '5px', 'anomica' ),
					'10px'		=> esc_attr__( '10px', 'anomica' ),
					'15px'		=> esc_attr__( '15px', 'anomica' ),
					'20px'		=> esc_attr__( '20px', 'anomica' ),
					'25px'		=> esc_attr__( '25px', 'anomica' ),
					'30px'		=> esc_attr__( '30px', 'anomica' ),
					'35px'		=> esc_attr__( '35px', 'anomica' ),
					'40px'		=> esc_attr__( '40px', 'anomica' ),
					'45px'		=> esc_attr__( '45px', 'anomica' ),
					'50px'		=> esc_attr__( '50px', 'anomica' ),
				]
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'appearance_section',
			[
				'label' => esc_attr__( 'Box Design', 'anomica' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
	
		$this->add_control(
			'column',
			[
				'label'			=> esc_attr__( 'Select Column', 'anomica' ),
				'description'	=> esc_attr__( 'Select column.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'five',
				'options'		=> [
					'one'				=> esc_attr__( 'One Column', 'anomica' ),
					'two'				=> esc_attr__( 'Two Column', 'anomica' ),
					'three'				=> esc_attr__( 'Three Column', 'anomica' ),
					'four'				=> esc_attr__( 'Four Column', 'anomica' ),
					'five'				=> esc_attr__( 'Five Column', 'anomica' ),
					'six'				=> esc_attr__( 'Six Column', 'anomica' ),
				],
			]
		);
		
		$this->add_control(
			'view-type',
			[
				'label'			=> esc_attr__( 'Box View', 'anomica' ),
				'description'	=> esc_attr__( 'Select box view. Show as normal row and column or show with carousel effect.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'carousel',
				'options'		=> [
					'default'	=> esc_attr__( 'Row and Column', 'anomica' ),
					'carousel'	=> esc_attr__( 'Carousel effect', 'anomica' ),
				]
			]
		);

		$this->add_control(
			'carousel_options',
			[
				'label' => esc_attr__( 'Carousel Settings', 'anomica' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'view-type' => 'carousel',
				]
			]
		);

		$this->add_control(
			'tm-autoplayspeed',
			[
				'label'			=> esc_attr__( 'Carousel: autoplaySpeed', 'anomica' ),
				'description'	=> esc_attr__( 'Carousel Effect: Slide/Fade animation speed.', 'anomica' ),
				'type'			=> Controls_Manager::TEXT,
				'default'		=> '4500',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);
		
		$this->add_control(
			'tm-loop',
			[
				'label'			=> esc_attr__( 'Carousel: Loop Item', 'anomica' ),
				'description'	=> esc_attr__( 'Carousel Effect: Infinite loop sliding.', 'anomica' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'anomica' ),
					'0'				=> esc_attr__( 'No', 'anomica' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'tm-autoplay',
			[
				'label'			=> esc_attr__( 'Carousel: Autoplay', 'anomica' ),
				'description'	=> esc_attr__( 'Carousel Effect: Enable/disable Autoplay', 'anomica' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '1',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'anomica' ),
					'0'				=> esc_attr__( 'No', 'anomica' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'carousel_slidestoscroll',
			[
				'label'			=> esc_attr__( 'Carousel: slidesToScroll', 'anomica' ),
				'description'	=> esc_attr__( '# of slides to scroll', 'anomica' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'1'				=> esc_attr__( '1 Slide', 'anomica' ),
					'column'		=> esc_attr__( 'Same as column', 'anomica' ),
				],
				'default'		=> '1',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);
		
		$this->add_control(
			'tm-centermode',
			[
				'label'			=> esc_attr__( 'Carousel: centerMode', 'anomica' ),
				'description'	=> esc_attr__( 'Enables centered view with partial prev/next slides. Use with odd numbered slidesToShow counts.', 'anomica' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'anomica' ),
					'0'				=> esc_attr__( 'No', 'anomica' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'carousel_nav',
			[
				'label'			=> esc_attr__( 'Carousel: Next/Prev Arrows', 'anomica' ),
				'description'	=> esc_attr__( 'Carousel Effect: Show dots navigation.', 'anomica' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'anomica' ),
					'0'				=> esc_attr__( 'No', 'anomica' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'carousel_arrowtype',
			[
				'label'			=> esc_attr__( 'Carousel:Button Type', 'anomica' ),
				'description'	=> esc_attr__( 'Carousel button type.', 'anomica' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'square'			=> esc_attr__( 'Square', 'anomica' ),
					'round'				=> esc_attr__( 'Round', 'anomica' ),
				],
				'default'		=> 'square',
				'condition'		=> [
					'view-type'		=> 'carousel',
					'carousel_nav'		=> '1',
				]
			]
		);
		
		$this->add_control(
			'carousel_dots',
			[
				'label'			=> esc_attr__( 'Carousel: dots', 'anomica' ),
				'description'	=> esc_attr__( 'Carousel Effect: Show dots navigation.', 'anomica' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'anomica' ),
					'0'				=> esc_attr__( 'No', 'anomica' ),
				],
				'default'		=> '0',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->end_controls_section();
		
$this->start_controls_section(
			'style_section',
			[
				'label' => esc_attr__( 'Typo Settings', 'anomica' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'heading_title',
				[
					'label' => esc_attr__( 'Heading', 'anomica' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'heading_color',
				[
					'label' => esc_attr__( 'Color', 'anomica' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .tm-element-content-heading' => 'color: {{VALUE}};',
						'{{WRAPPER}} .tm-element-content-heading > a' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'heading_typography',
					'selector' => '{{WRAPPER}} .tm-element-content-heading',
				]
			);
			$this->add_responsive_control(
				'heading_bottom_space',
				[
					'label' => esc_attr__( 'Spacing', 'anomica' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .tm-element-content-heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'heading_subheading',
				[
					'label' => esc_attr__( 'Sub Heading', 'anomica' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'stitle_color',
				[
					'label' => esc_attr__( 'Color', 'anomica' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .tm-element-subheading' => 'color: {{VALUE}};',
						'{{WRAPPER}} .tm-element-subheading > a' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'subheading_typography',
					'selector' => '{{WRAPPER}} .tm-element-subheading',
				]
			);
			$this->add_responsive_control(
				'subheading_bottom_space',
				[
					'label' => esc_attr__( 'Spacing', 'anomica' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .tm-element-subheading' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);

			$this->add_control(
				'heading_desc',
				[
					'label' => esc_attr__( 'Description', 'anomica' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'desc_color',
				[
					'label' => esc_attr__( 'Color', 'anomica' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .tm-element-content-desctxt' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .tm-element-content-desctxt',
				]
			);
			$this->add_responsive_control(
				'desc_bottom_space',
				[
					'label' => esc_attr__( 'Spacing', 'anomica' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .tm-element-content-desctxt' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();
		
	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);

		$start_div = ttm_element_container( array(
			'position'	=> 'start',
			'cpt'		=> 'client',
			'data'		=> $settings
		) );

		echo themetechmount_wp_kses($start_div);

		$args = array(
			'post_type'				=> 'tm_client',
			'posts_per_page'		=> $show,
			'ignore_sticky_posts'	=> true,
		);

		if( !empty($orderby) && $orderby!='none' ){
			$args['orderby'] = $orderby;
			if( !empty($order) ){
				$args['order'] = $order;
			}
		}

		if( !empty($from_category) ){
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'tm_client_group',
					'field'    => 'slug',
					'terms'    => $from_category,
				),
			);
		};

		$posts = new \WP_Query( $args );
		
		$headingclass= '';
		if( empty($settings['heading']) ){
			$headingclass = 'tm-boxwithout-heading';
		}

		if ( $posts->have_posts() ) {
			?>

			<div class="themetechmount-box-heading-wrapper <?php echo themetechmount_wp_kses($headingclass); ?>">
				<?php tm_heading_subheading($settings, true); ?>
				<?php
				if( function_exists('sortable_category') ){
					$sortable_category_html = sortable_category( $settings, 'tm_client_group' );
					echo  themetechmount_wp_kses($sortable_category_html);
				}
				?>
			</div>

			<div class="themetechmount-boxes-row-wrapper row multi-columns-row">

			<?php
			while ( $posts->have_posts() ) {
				$return = '';
				$posts->the_post();
				
				if( file_exists( locate_template( '/template-parts/clientbox/clientbox-'.esc_attr($style).'.php', false, false ) ) ){

					$return .= ttm_element_block_container( array(
						'position'	=> 'start',
						'column'	=> $column,
						'cpt'		=> 'client',
						'taxonomy'	=> 'tm_client_group',
						'style'		=> $style,
					) );

					ob_start();
					$r = include( locate_template( '/template-parts/clientbox/clientbox-'.esc_attr($style).'.php', false, false ) );
					$return .= ob_get_contents();
					ob_end_clean();

					$return .= ttm_element_block_container( array(
						'position'	=> 'end',
					) );

				}

				echo themetechmount_wp_kses($return);

			}
			?>

			</div>

			<?php
		}
		
		wp_reset_postdata();

		$end_div = ttm_element_container( array(
			'position'	=> 'end',
			'cpt'		=> 'client',
			'data'		=> $settings
		) );
		echo themetechmount_wp_kses($end_div);
	}


	protected function select_category() {
	  	$category = get_terms( array( 'taxonomy' => 'tm_client_group', 'hide_empty' => false ) );
	  	$cat = array();
	  	foreach( $category as $item ) {
			$cat_count = get_category( $item );

	     	if( $item ) {
	        	$cat[$item->slug] = $item->name . ' ('.$cat_count->count.')';
	     	}
	  	}
	  	return $cat;
	}

	
}
// Register widget
Plugin::instance()->widgets_manager->register_widget_type( new Anomica_Clientbox_Widget() );