<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  ThemetechMount Price Table
*/

class Anomica_Pricetable_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_ptable_element';
	}

	public function get_title() {
		return esc_attr__( 'Pricing Table', 'anomica' );
	}

	public function get_icon() {
		return 'eicon-price-table';
	}

	public function get_categories() {
		return [ 'anomica_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}

	protected function register_controls() {

		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_attr__( 'General', 'anomica' ),
			]
		);
		
		$this->add_control(
			'style',
			[
				'label'			=> esc_attr__( 'Select Pricetable Style', 'anomica' ),
				'description'	=> esc_attr__( 'Select Pricetable style.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'options' => [
						'style-1' => esc_attr( 'Style 1' ),	
					],
				'default' => esc_attr( 'style-1' ),
			]
		);
		
		$this->add_control(
			'heading',
			[
				'label' => esc_attr__( 'Heading', 'anomica' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'Enter Your Heading', 'anomica' ),
				'placeholder' => esc_attr__( 'Enter text for heading line.', 'anomica' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'subheading',
			[
				'label' => esc_attr__( 'Subheading', 'anomica' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( '', 'anomica' ),
				'placeholder' => esc_attr__( 'Enter text for subheading line.', 'anomica' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'reverse_heading',
			[
				'label' => esc_attr__( 'Reverse heading order', 'anomica' ),
				'description' => esc_attr__( 'Show sub-heading before heading.', 'anomica' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_attr__( 'Yes', 'anomica' ),
				'label_off' => esc_attr__( 'No', 'anomica' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		$this->add_control(
			'desc',
			[
				'label' => esc_attr__( 'Description', 'anomica' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_attr__( 'Enter description text', 'anomica' ),
			]
		);
		
		$this->add_control(
			'heading_sep',
			[
				'label' => esc_attr__( 'Seperator', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none'	=> esc_attr( 'None' ),
					'solid'	=> esc_attr( 'Solid' ),
					'style1'	=> esc_attr( 'Style1' ),
				],
				'default' => esc_attr( 'none' ),
			]
		);
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_attr__( 'Text alignment', 'anomica' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_attr__( 'Left', 'anomica' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_attr__( 'Center', 'anomica' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_attr__( 'Right', 'anomica' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'tm-align-',
				'selectors' => [
					'{{WRAPPER}} .tm-heading-subheading' => 'text-align: {{VALUE}};',
				],
				'dynamic' => [
					'active' => true,
				],
				'default' => 'left',
			]
		);
		
		$this->add_control(
			'heading_style',
			[
				'label'			=> esc_attr__( 'Heading Style', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'vertical'	=> esc_attr( 'Vertical (Default)' ),
					'horizontal'	=> esc_attr( 'Horizontal' ),
				],
				'default' => esc_attr( 'vertical' ),
			]
		);

		$this->add_control(
			'tag_options',
			[
				'label'			=> esc_attr__( 'Tags for SEO', 'anomica' ),
				'type'			=> Controls_Manager::HEADING,
				'separator'		=> 'before',
			]
		);
		$this->add_control(
			'heading_tag',
			[
				'label' => esc_attr__( 'Heading Tag', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h2' ),
			]
		);
		
		$this->add_control(
			'subheading_tag',
			[
				'label' => esc_attr__( 'Subheading Tag', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h4' ),
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
            'highlight_col_section',
            [
                'label' => esc_attr__( 'Featured Column', 'anomica' ),
            ]
        );
        $this->add_control(
			'highlight_col',
			[
				'label' => esc_attr__( 'Featured Column', 'anomica' ),
				'description' => esc_attr__( 'Select whith column will be with featured style.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'	=> esc_attr__( 'First Column', 'anomica' ),
                    '2'	=> esc_attr__( 'Second Column', 'anomica' ),
					'3'	=> esc_attr__( 'Third Column', 'anomica' ),
					'4'	=> esc_attr__( 'Fourth Column', 'anomica' ),
					'5'	=> esc_attr__( 'Fifth Column', 'anomica' ),
				],
				'default' => esc_attr( '2' ),
			]
		);
		$this->add_control(
			'highlight_text',
			[
				'label' => esc_attr__( 'Feature Column Heading', 'anomica' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'Featured', 'anomica' ),
				'placeholder' => esc_attr__( 'Enter text used as main heading for feature column. Some HTML tags are allowed.', 'anomica' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		for( $x=1; $x<=5; $x++ ){

			$this->start_controls_section(
				$x.'_col_section',
				[
					'label' => sprintf( esc_attr__( '%1$s Column in Pricing Table', 'anomica' ) , tm_ordinal($x) ) ,
				]
			);


			$this->add_control(
				$x.'_heading',
				[
					'label'         => esc_attr__( 'Heading', 'anomica' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Enter text used as main heading. This will be plan title like "Basic", "Pro" etc.', 'anomica' ),
					'separator'     => 'after',
					'label_block'   => true,
				]
			);
			$this->add_control(
				$x.'_description',
				[
					'label'         => esc_attr__( 'Description', 'anomica' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Enter description text', 'anomica' ),
					'separator'     => 'after',
					'label_block'   => true,
				]
			);

			$this->add_control(
				$x.'_price',
				[
					'label'         => esc_attr__( 'Price', 'anomica' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Enter Price.', 'anomica' ),
				]
			);
			
			$this->add_control(
				$x.'_cur_symbol',
				[
					'label'         => esc_attr__( 'Currency symbol', 'anomica' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Enter currency symbol', 'anomica' ),
				]
			);
			
			$this->add_control(
				$x.'_cur_symbol_position',
				[
					'label'			=> esc_html__( 'Currency Symbol position', 'anomica' ),
					'description'	=> esc_html__( 'Select currency position.', 'anomica' ),
					'type'			=> Controls_Manager::SELECT,
					'default'		=> 'after',
					'options' => [
						'after'		=> __( 'After Price', 'anomica' ),
						'before'	=> __( 'Before Price', 'anomica' ),
					],
				]
			);
			$this->add_control(
				$x.'_price_frequency',
				[
					'label'         => esc_attr__( 'Price Frequency', 'anomica' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Enter currency frequency like "Monthly", "Yearly" or "Weekly" etc.', 'anomica' ),
					'separator'     => 'after',
				]
			);
			
			$this->add_control(
				$x.'_btn_text',
				[
					'label'         => esc_attr__( 'Button Text', 'anomica' ),
					'type'          => Controls_Manager::TEXT,
					'description'   => esc_attr__( 'Like "Read More" or "Buy Now".', 'anomica' ),
				]
			);
			
			$this->add_control(
				$x.'_btn_link',
				[
					'label'         => esc_attr__( 'Button Link', 'anomica' ),
					'type'          => Controls_Manager::URL,
					'description'   => esc_attr__( 'Set link for button', 'anomica' ),
					'separator'     => 'after',
				]
			);

			$repeater = new Repeater();

			$repeater->add_control(
				'text',
				[
					'label' => __( 'Line Label', 'anomica' ),
					'type' => Controls_Manager::TEXT,
					'label_block' => true,
				]
			);

			$this->add_control(
				$x.'_lines',
				[
					'label'			=> esc_attr__( 'Each Line (Features)', 'anomica' ),
					'description'	=> esc_attr__( 'Enter features that will be shown in spearate lines.', 'anomica' ),
					'type'			=> Controls_Manager::REPEATER,
					'fields'		=> $repeater->get_controls(),
					'default'		=> [
						[
							'text'		=> esc_attr__( 'This is label one', 'anomica' ),
						],
						[
							'text'		=> esc_attr__( 'This is label two', 'anomica' ),
						],
						[
							'text'		=> esc_attr__( 'This is label three', 'anomica' ),
						],
					],
					'title_field' => '{{{ text }}}',
				]
			);

			$this->end_controls_section();

		}

	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		$return = '';
		?>
		<?php tm_heading_subheading($settings, true); ?>
		<div class="tm-ptablebox tm-ptablebox-<?php echo esc_attr($style); ?>">

			<?php
			$columns = array();
			for ($x = 0; $x <= 5; $x++) {
				if( !empty( $settings[$x.'_heading'] ) ){
					$columns[$x] = $x;
				}
			}

			$col_start_div	= '';
			$col_end_div	= '';
			if( !empty($columns) ){
				switch( count($columns) ){
					case 1:
						$col_start_div	= '<div class="ttm-pricetable-column-w tm-ptable-col col-md-12">';
						$col_end_div	= '</div>';
						break;

					case 2:
						$col_start_div	= '<div class="ttm-pricetable-column-w">';
						$col_end_div	= '</div>';
						break;

					case 3:
						$col_start_div	= '<div class="ttm-pricetable-column-w">';
						$col_end_div	= '</div>';
						break;

					case 4:
						$col_start_div	= '<div class="ttm-pricetable-column-w">';
						$col_end_div	= '</div>';
						break;

					case 5:
						$col_start_div	= '<div class="ttm-pricetable-column-w">';
						$col_end_div	= '</div>';
						break;
				}
			}

			if( !empty($columns) ){

				$return .= '<div class="themetechmount-ptables-w wpb_content_element">';

				foreach( $columns as $col => $highlight_col ){


					$featured = '';
					if( $settings['highlight_col'] == $col ){
						$col_start_div = str_replace( 'class="', 'class="tm-ptablebox-featured-col ', $col_start_div );
						$featured = ( !empty($settings['highlight_text']) ) ? '<div class="ttm-featured-title">'.$settings['highlight_text'].'</div>' : '' ;
					} else {
						$col_start_div = str_replace( 'class="tm-ptablebox-featured-col ', 'class="', $col_start_div );
					}

					$heading = ( !empty($settings[$col.'_heading']) ) ? '<div class="tm-ptablebox-title"><h3>'.$settings[$col.'_heading'].'</h3></div>' : '' ;
					
					$description = ( !empty($settings[$col.'_description']) ) ? '<div class="tm-ptablebox-description">'.$settings[$col.'_description'].'</div>' : '' ;

					$currency_symbol = ( !empty($settings[$col.'_cur_symbol']) ) ? '<div class="tm-ptablebox-cur-symbol-'.$settings[$col.'_cur_symbol_position'].'">'.$settings[$col.'_cur_symbol'].'</div>' : '' ;

					$frequency = ( !empty($settings[$col.'_price_frequency']) ) ? '<div class="tm-ptablebox-frequency">'.$settings[$col.'_price_frequency'].'</div>' : '' ;
				
					$price = ( !empty($settings[$col.'_price']) ) ? '<div class="tm-ptablebox-price">'.$settings[$col.'_price'].'</div>' : '' ;
					
					$price = ( !empty($settings[$col.'_cur_symbol_position']) && $settings[$col.'_cur_symbol_position']=='before' ) ? $currency_symbol.' '.$price : $price.' '.$currency_symbol ;

					$lines_html = '';
					$values     = (array) $settings[$col.'_lines'];
					if( is_array($values) && count($values)>0 ){
						foreach ( $values as $data ) {

				
							$lines_html .= isset( $data['text'] ) ? '<li class="tm-ptable-line">'.$data['text'].'</li>' : '';
						}
					}

					$button = '';
					if( !empty($settings[$col.'_btn_text']) && !empty($settings[$col.'_btn_link']['url']) ){
						$button = '<div class="tm-vc_btn3-container tm-vc_btn3-inline"><div class="tm-vc_general tm-vc_btn3 tm-vc_btn3-size-md tm-vc_btn3-shape-square tm-vc_btn3-style-flat tm-vc_btn3-weight-no tm-vc_btn3-color-grey">' . tm_link_render($settings[$col.'_btn_link'], 'start' ) . themetechmount_wp_kses($settings[$col.'_btn_text']) . tm_link_render($settings[$col.'_btn_link'], 'end' ) . '</div></div>';
					}

					$return .= $col_start_div;
					ob_start();
					include( get_template_directory() . '/template-parts/pricingtable/pricetable-'.esc_attr($style).'.php' );
					$return .= ob_get_contents();
					ob_end_clean();
					$return .= $col_end_div;
				}

				$return .= '</div>';

			}

			echo themetechmount_wp_kses($return);
			?>

		</div>

		<?php

	}
	
}
// Register widget
Plugin::instance()->widgets_manager->register_widget_type( new Anomica_Pricetable_Widget() );