<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Fact & Digit Widget.
*/
 
class Boldman_Imagebox_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_imagebox_element';
	}

	public function get_title() {
		return esc_attr__( 'Image Box', 'anomica' );
	}

	public function get_icon() {
		return 'eicon-image';
	}

	public function get_categories() {
		return [ 'anomica_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}  
	
	protected function register_controls() {

		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Content', 'anomica' ),
			]
        );
		
		
		$this->add_control(
			'view',
			[
				'label'			=> esc_attr__( 'Design', 'anomica' ),
				'description'	=> esc_attr__( 'Select box design.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'one',
				'options' => [
					'one'	=> esc_attr( 'Style 1' ),
					'two'	=> esc_attr( 'Style 2' ),
					'three'	=> esc_attr( 'Style 3' ),
					'four'	=> esc_attr( 'Style 4' ),
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label'			=> esc_attr__( 'Choose Image', 'anomica' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'image',
				'default' => 'large',
				'separator' => 'none',
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'anomica' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'anomica' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'anomica' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'anomica' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();

	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		
		global $tm_global_imagebox_element_values;
		$tm_global_imagebox_element_values = array();
		
		$return = '';


		$class         = array();

		if( !empty($view) ){
			$class[] = 'tm-imgbox-'.$view;
		}

		
		// Media image
			$image_html		= '' ;
			if( defined('ELEMENTOR_VERSION') ){
				$image_html = Group_Control_Image_Size::get_attachment_image_src( $settings['image']['id'], 'image', $settings );
				if( !empty($image_html) ){
					$image_html = '<img src="'.esc_url($image_html).'" class="tm-single-image-img" alt="Image"/>';
				}

			}
			
			
		if( file_exists( locate_template( '/template-parts/imagebox/imagebox.php', false, false ) ) ){

			ob_start();
			include( locate_template( '/template-parts/imagebox/imagebox.php', false, false ) );
			$return .= ob_get_contents();
			ob_end_clean();

		}
		
		echo themetechmount_wp_kses($return);

	}


}
// Register widget
Plugin::instance()->widgets_manager->register_widget_type( new Boldman_Imagebox_Widget() );