<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Fact & Digit Widget.
*/
 
class Anomica_Fidbox_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_fid_element';
	}

	public function get_title() {
		return esc_attr__( 'Facts in digits', 'anomica' );
	}

	public function get_icon() {
		return 'eicon-counter';
	}

	public function get_categories() {
		return [ 'anomica_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
		wp_enqueue_script( 'waypoints' );
		wp_enqueue_script( 'numinate' );
		wp_enqueue_script( 'jquery-circle-progress' );
	}  
	
	protected function register_controls() {

		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Content', 'anomica' ),
			]
        );
		
		
		$this->add_control(
			'view',
			[
				'label'			=> esc_attr__( 'Design', 'anomica' ),
				'description'	=> esc_attr__( 'Select box design.', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'topicon',
				'options' => [
					'topicon'	=> esc_attr( 'Top Center icon' ),
					'lefticon'	=> esc_attr( 'Left Icon' ),
					'righticon'	=> esc_attr( 'Right Icon' ),
					'circle-progress'	=> esc_attr( 'Circle Progress Style' ),
					'style7'	=> esc_attr( 'style7' ),
					'circle-progress2'	=> esc_attr( 'Circle Progress Style2' ),
				],
			]
		);
		$this->add_control(
			'icon_type',
			[
				'label' => esc_attr__( 'Icon Type', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'icon'	=> esc_attr__( 'Icon', 'anomica' ),
					'image'	=> esc_attr__( 'Image', 'anomica' ),
					'text'	=> esc_attr__( 'Text', 'anomica' ),
				],
				'default' => esc_attr( 'icon' ),
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'anomica' ),
				'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'icon_type' => 'icon',
                ]
            ]

		);

        $this->add_control(
			'icon_image',
			[
				'label' => __( 'Select Image for Icon', 'anomica' ),
				'description' => __( 'image will appear at icon position', 'anomica' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
			]
		);
		
        $this->add_control(
			'icon_text',
			[
				'label' => esc_attr__( 'Text for Icon', 'anomica' ),
				'description' => esc_attr__( 'Text will appear at icon position', 'anomica' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( '01', 'anomica' ),
				'placeholder' => esc_attr__( 'Enter text here', 'anomica' ),
                'label_block' => true,
                'condition' => [
                    'icon_type' => 'text',
                ]
			]
		);


		$this->add_control(
			'title',
			[
				'label' => esc_attr__( 'Header ', 'anomica' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'Title Text. ', 'anomica' ),
				'placeholder' => esc_attr__( 'Enter text for the title. ', 'anomica' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'desc',
			[
				'label' => esc_attr__( 'Description Text', 'anomica' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_attr__( 'Enter description text', 'anomica' ),
				'label_block' => true,
				'condition' => [
					'view' => ['style6','circle-progress2'],
				],
			]
		);

		$this->add_control(
			'digit',
			[
				'label' => esc_attr__( 'Rotating Number', 'anomica' ),
				'description' => esc_attr__( 'Enter rotating number digit here.', 'anomica' ),
				'separator' => 'before',
				'type' => Controls_Manager::NUMBER,
				'default' => '50',
			]
		);

		$this->add_control(
			'interval',
			[
				'label' => esc_attr__( 'Rotating digit Interval', 'anomica' ),
				'description' => esc_attr__( 'Enter rotating interval number here.', 'anomica' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '5',
			]
		);

		$this->add_control(
			'before',
			[
				'label' => esc_attr__( 'Text Before Number', 'anomica' ),
				'description' => esc_attr__( 'Enter text which appear just before the rotating numbers.', 'anomica' ),
				'separator' => 'before',
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => '',
			]
		);

		$this->add_control(
			'beforetextstyle',
			[
				'label' => esc_attr__( 'Text Style', 'anomica' ),
				'description' => esc_attr__('Select text style for the before text.', 'anomica'),
				'type' => Controls_Manager::SELECT,
				'default' => 'sup',
				'options' => [
					'sup'		=> esc_attr__( 'Superscript', 'anomica' ),
					'sub'		=> esc_attr__( 'Subscript', 'anomica' ),
					'span'		=> esc_attr__( 'Normal', 'anomica' ),
				]
			]
		);

		$this->add_control(
			'after',
			[
				'label' => esc_attr__( 'Text After Number', 'anomica' ),
				'description' => esc_attr__( 'Enter text which appear just after the rotating numbers.', 'anomica' ),
				'type' => Controls_Manager::TEXT,
				'separator' => 'before',
				'dynamic' => [
					'active' => true,
				],
				'default' => '',
			]
		);

		$this->add_control(
			'aftertextstyle',
			[
				'label' => esc_attr__( 'Text Style', 'anomica' ),
				'description' => esc_attr__('Select text style for the after text.', 'anomica'),
				'type' => Controls_Manager::SELECT,
				'default' => 'sup',
				'options' => [
					'sup'		=> esc_attr__( 'Superscript', 'anomica' ),
					'sub'		=> esc_attr__( 'Subscript', 'anomica' ),
					'span'		=> esc_attr__( 'Normal', 'anomica' ),
				]
			]
		);
		
		$this->add_control(
			'circle_fill_color',
			[
				'label' => esc_attr__( 'Circle fill color', 'anomica' ),
				'description'	=> esc_attr__( 'Select circle fill color..', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'skincolor',
				'options' => [
					'skincolor'		=> esc_attr__( 'Skincolor', 'anomica' ),
					'20292f'		=> esc_attr__( 'Dark Grey', 'anomica' ),
					'#fff'			=> esc_attr__( 'White', 'anomica' ),
				],
				'condition' => [
					'view' => ['circle-progress','circle-progress2'],
				],
			]
		);
		$this->add_control(
			'circle_empty_color',
			[
				'label' => esc_attr__( 'Circle empty color', 'anomica' ),
				'description'	=> esc_attr__( 'Select circle empty color..', 'anomica' ),
				'type' => Controls_Manager::SELECT,
				'default' => '20292f',
				'options' => [
					'skincolor'		=> esc_attr__( 'Skincolor', 'anomica' ),
					'20292f'		=> esc_attr__( 'Dark Grey', 'anomica' ),
					'#fff'		=> esc_attr__( 'White', 'anomica' ),
				],
				'condition' => [
					'view' => ['circle-progress','circle-progress2'],
				],
			]
		);
		

		$this->end_controls_section();

	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		
		global $tm_global_fid_element_values;
		$tm_global_fid_element_values = array();
		
		$tm_global_fid_element_values['circle_fill_color']  = $circle_fill_color;
		$tm_global_fid_element_values['circle_empty_color']  = $circle_empty_color;

      

		$return = $icon = '';

		$lefticoncode  = '';
		$righticoncode = '';
		if( !empty($settings['icon']['value']) ){ 
			$lefticoncode = '<div class="tm-fid-icon-wrapper"><i class="' . esc_attr($settings['icon']['value']) . '"></i></div>';
		} 
		$class         = array();
		$class_icon         = 'tm-fid-without-icon';
		if( !empty($settings['icon']['value']) ){ 
			$class_icon = 'tm-fid-with-icon';	
			
		}  // if( $add_icon=='true' )
		
		// icon exists class
		$class[] = $class_icon;
		
		if( !empty($view) ){
			$class[] = 'tm-fid-view-'.$view;
		}
			
		$before_text = '';
		$after_text  = '';
		
		if( trim($before)!='' ){
			if( $beforetextstyle=='sup' || $beforetextstyle=='sub' || $beforetextstyle=='span' ){
				$before_text = '<'.$beforetextstyle.'>'.trim($before).'</'.$beforetextstyle.'>';
			}
		}
		
		if( trim($after)!='' ){
			if( $aftertextstyle=='sup' || $aftertextstyle=='sub' || $aftertextstyle=='span' ){
				$after_text = '<'.$aftertextstyle.'>'.trim($after).'</'.$aftertextstyle.'>';
			}
		}
			$view_class=implode(' ', $class);

		
		 if( file_exists( locate_template( '/template-parts/fidbox2/fidbox-'.esc_attr($view).'.php', false, false ) ) ){
			$icon_type_class = '';

			if( !empty($settings['icon_type']) ){

				if( $settings['icon_type']=='text' ){
					$icon_html = '<div class="tm-icon-type-text">' . $settings['icon_text'] . '</div>';
					$icon_type_class = 'text';

				} else if( $settings['icon_type']=='image' ){
					$icon_alt	= (!empty($settings['title'])) ? trim($settings['title']) : esc_attr__('Icon', 'anomica') ;
					$icon_image = '<img src="'.esc_url($settings['icon_image']['url']).'" alt="'.esc_attr($icon_alt).'" />';
					$icon_html	= '<div class="tm-icon-type-image">' . $icon_image . '</div>';
					$icon_type_class = 'image';
				} else if( $settings['icon_type']=='none' ){
					$icon_html = '';
					$icon_type_class = 'none';
				} else {

					$icon_html       = '<div class="tm-box-icon"><i class="' . $settings['icon']['value'] . '"></i></div>';
					$icon_type_class = 'icon';

					wp_enqueue_style( 'elementor-icons-'.$settings['icon']['library']);
				}
			}
			
			ob_start();
			include( locate_template( '/template-parts/fidbox2/fidbox-'.esc_attr($view).'.php', false, false ) );
			$return .= ob_get_contents();
			ob_end_clean();
	   }
	   
		
		echo themetechmount_wp_kses($return);

	}


}
// Register widget
Plugin::instance()->widgets_manager->register_widget_type( new Anomica_Fidbox_Widget() );