<?php

/**
 *  ThemetechMount: Static Content Box
 */

// Icon picker
$icons_params = vc_map_integrate_shortcode( 'tm-icon', 'i_', '',
	array(
		'include_only_regex' => '/^(type|icon_\w*)/',
	)
);

$param_group = array(
				array(
						'type'        => 'textfield',
						'heading'     => esc_attr__( 'Box Title', 'anomica' ),
						'param_name'  => 'static_boxtitle',
						'description' => esc_attr__( 'Enter text used as title', 'anomica' ),
						'group'       => esc_attr__( 'Content', 'anomica' ),
						'admin_label' => true,
				),
				array(
						'type'        => 'textarea',
						'heading'     => esc_attr__( 'Box Content', 'anomica' ),
						'param_name'  => 'static_boxcontent',
						'description' => esc_attr__( 'Enter box content', 'anomica' ),
						'group'       => esc_attr__( 'Content', 'anomica' ),
						'admin_label' => true,
				),
				array(
						'type'        => 'textfield',
						'heading'     => esc_attr__( 'Button text', 'anomica' ),
						'param_name'  => 'static_buttontitle',
						'description' => esc_attr__( 'Enter text used for button', 'anomica' ),
						'group'       => esc_attr__( 'Content', 'anomica' ),
						'admin_label' => true,
				),
				array(
						'type'        => 'vc_link',
						'heading'     => esc_attr__( 'Button URL (Link)', 'anomica' ),
						'param_name'  => 'static_boxlink',
						'description' => esc_attr__( 'Add link for box button', 'anomica' ),
						'group'       => esc_attr__( 'Content', 'anomica' ),
						'admin_label' => true,
				),
       			
			);
// Merging icon with other options
$param_group = array_merge( $param_group, $icons_params );	
	
	$params  = array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_attr__( 'Extra class name', 'anomica' ),
				'param_name'  => 'el_class',
				'description' => esc_attr__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'anomica' ),
			),
			array(
				'type' => 'param_group',
				'heading' => esc_attr__( 'Box Content', 'anomica' ),
				'param_name' => 'box_content',
				'group'       => esc_attr__( 'Content', 'anomica' ),
				'description' => esc_attr__( 'Set box content', 'anomica' ),
				'params' => $param_group,
			),			
	);
	
	
	
/**
 * Heading Element
 */
$heading_element = vc_map_integrate_shortcode( 'tm-heading', '', '',
	array(
		'exclude' => array(
			'el_class',
			'css',
			'css_animation'
		),
	)
);

$boxParams = themetechmount_box_params();
$params    = array_merge( $heading_element, $params, $boxParams );

	
	global $tm_vc_custom_element_staticcontent_box;
	$tm_vc_custom_element_staticcontent_box = $params;
	
	

	vc_map( array(
		'name'        => esc_attr__( 'ThemetechMount History Box', 'anomica' ),
		'base'        => 'tm-static-contentbox',
		"class"    => "",
		"icon"        => "icon-themetechmount-vc",
		'category'    => esc_attr__( 'ThemetechMount Special Elements', 'anomica' ),
		'params'      => $params,
	) );