<?php

/**
 *  ThemetechMount: Process Box
 */


	$allParams =
		array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_attr__( 'Extra class name', 'anomica' ),
				'param_name'  => 'el_class',
				'description' => esc_attr__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'anomica' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_attr__( 'Box Image size', 'anomica' ),
				'param_name'  => 'boximg_size',
				'value'			=> 'full',
				'description' => esc_attr__( 'Enter image size (Example: "thumbnail", "medium", "large", "full"). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 'anomica' ),
				'group'       => esc_attr__( 'Content', 'anomica' ),
			),
			array(
			'type' => 'param_group',
			'heading' => esc_attr__( 'Box Content', 'anomica' ),
			'param_name' => 'box_content',
			'group'       => esc_attr__( 'Content', 'anomica' ),
			'description' => esc_attr__( 'Set box content', 'anomica' ),
			'params' => array(
			    array(
						'type'        => 'attach_image',
						'heading'     => esc_attr__( 'Box Image', 'anomica' ),
						'param_name'  => 'static_boximage',
						'description' => esc_attr__( 'Select image', 'anomica' ),
						'group'       => esc_attr__( 'Content', 'anomica' ),
						'admin_label' => true,
						'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
						'type'        => 'textfield',
						'heading'     => esc_attr__( 'Box Title', 'anomica' ),
						'param_name'  => 'static_boxtitle',
						'description' => esc_attr__( 'Enter text used as title', 'anomica' ),
						'group'       => esc_attr__( 'Content', 'anomica' ),
						'admin_label' => true,
				),
				array(
						'type'        => 'textarea',
						'heading'     => esc_attr__( 'Box Content', 'anomica' ),
						'param_name'  => 'static_boxcontent',
						'description' => esc_attr__( 'Enter box content', 'anomica' ),
						'group'       => esc_attr__( 'Content', 'anomica' ),
						'admin_label' => true,
				),
                array(
						'type'        => 'vc_link',
						'heading'     => esc_attr__( 'Box URL (Link)', 'anomica' ),
						'param_name'  => 'static_boxlink',
						'description' => esc_attr__( 'Add link for box title and image', 'anomica' ),
						'group'       => esc_attr__( 'Content', 'anomica' ),
						'admin_label' => true,
				),				
						
			),
		),
			
	);
	
/**
 * Heading Element
 */
$heading_element = vc_map_integrate_shortcode( 'tm-heading', '', '',
	array(
		'exclude' => array(
			'el_class',
			'css',
			'css_animation'
		),
	)
);


$params    = array_merge( $heading_element, $allParams );

	
	global $tm_vc_custom_element_processbox;
	$tm_vc_custom_element_processbox = $params;
	
	

	vc_map( array(
		'name'        => esc_attr__( 'ThemetechMount Process Box', 'anomica' ),
		'base'        => 'tm-processbox',
		"class"    => "",
		"icon"        => "icon-themetechmount-vc",
		'category'    => esc_attr__( 'ThemetechMount Special Elements', 'anomica' ),
		'params'      => $params,
	) );