<?php
/*
 * Plugin Name: ThemetechMount Anomica Demo Content Setup
 * Plugin URI: https://www.themetechmount.com
 * Description: Anomica Demo Content Setup Plugin By ThemetechMount
 * Version: 1.0
 * Author: ThemetechMount
 * Author URI: https://www.themetechmount.com
 * Text Domain: anomica-demosetup
 * Domain Path: /languages
 */
 
 
 
/**
 *  Version and directory
 */
define( 'ANOMICA_TMDC_VERSION', '1.0' );
define( 'ANOMICA_TMDC_DIR', plugin_dir_path( __FILE__ ) );
define( 'ANOMICA_TMDC_URI', plugins_url( '', __FILE__ ) );



/**
 *  Demo Content setup
 */
require_once ANOMICA_TMDC_DIR . 'one-click-demo/demo-content.php';



/**
 *  Translation
 */
function anomica_demosetup_load_plugin_textdomain() {
	$domain = 'anomica-demo-content-setup';
	$locale = apply_filters( 'plugin_locale', get_locale(), $domain );
	if ( $loaded = load_textdomain( 'anomica-demosetup', trailingslashit( WP_LANG_DIR ) . $domain . '/' . $domain . '-' . $locale . '.mo' ) ) {
		return $loaded;
	} else {
		load_plugin_textdomain( 'anomica-demosetup', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
	}
}
add_action( 'init', 'anomica_demosetup_load_plugin_textdomain' );



/**
 * Load plugin textdomain.
 *
 * @since 1.0.0
 */
function anomica_demosetup_load_textdomain() {
	load_plugin_textdomain( 'anomica-demosetup', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
}
add_action( 'plugins_loaded', 'anomica_demosetup_load_textdomain' );







function anomica_demo_content_scripts_styles(){

	wp_enqueue_style(
		'tm-one-click-demo-style',
		plugin_dir_url( __FILE__ ) . 'style.css',
		time(),
		true
	);
	wp_enqueue_script(
		'tm-one-click-demo-set-js',
		plugin_dir_url( __FILE__ ) . 'functions.js',
		array( 'jquery' ),
		time(),
		true
	);
	


}
add_action( 'admin_enqueue_scripts', 'anomica_demo_content_scripts_styles', 20 );



/**
 * HTML Output for the one click demo setup
 *
 * @since 1.0.0
 */
if( !function_exists('themetechmount_anomica_one_click_html') ){
function themetechmount_anomica_one_click_html() {
	?>
	
	<div id="import-demo-data-results">
				
		<div class="import-demo-data-text-w">
		
			<div class="import-demo-data-layout">
				<!-- <h3>Select demo data type  <small>(select below)</small>: </h3> -->
				
				<div class="tm-import-demo-left">
					<div class="tm-import-demo-left-inner">
						
						<select id="import-layout-type" name="import-layout-type">
							<option value="Classic">Classic Site</option>
							<option value="Overlay">Overlay Site</option>
							<option value="Infostack">Infostack Site</option>
							<option value="Classicinfo">ClassicInfo Site</option>
							<option value="RTL">RTL Site</option>								
							<option value="Landing">App Landing Site</option>								
							<option value="classic-elementor">Classic Site (Elementor Builder)</option>
							<option value="overlay-elementor">Overlay Site (Elementor Builder)</option>
							<option value="infostack-elementor">Infostack Site (Elementor Builder)</option>
							<option value="classicinfo-elementor">Classicinfo Site (Elementor Builder)</option>
							<option value="demo2">Demo2 (Elementor Builder)</option>
							<option value="advanced">Advanced Demo</option>
							<option value="onepage-elementor">Onepage Site (Elementor Builder)</option>
						</select>
						
						<br><br><hr>
						
						<div class="import-demo-data-text">
						
							<strong><?php esc_attr_e('NOTE:', 'anomica'); ?></strong>
							<?php esc_attr_e('This process may overwrite your existing content or settings. So please do this on fresh WordPress setup only.', 'anomica'); ?>
							<br /><br />
							<?php esc_attr_e('Also if you already included demo data than this will add multiple menu links and you need to remove the repeated menu items by going to "Admin > Appearance > menus" section.', 'anomica'); ?>
							
						</div>

						
					</div>
				</div>
				
				<div class="tm-import-demo-right">
				
					<!-- classic -->
					<span class="import-demo-thumb-w import-demo-thumb-classic">
						<div class="tm-import-demo-preview-text">Preview:</div>					
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-classic.png" alt="Classic">
					</span>
					
					<!-- overlay -->
					<span class="import-demo-thumb-w import-demo-thumb-overlay" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="http://anomica.themetechmount.net/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-overlay.png" alt="Overlay">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
					<!-- Infostack -->
					<span class="import-demo-thumb-w import-demo-thumb-infostack" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="http://anomica.themetechmount.net/header-infostack/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-infostack.png" alt="Infostack">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					

					<!-- ClassicInfo -->
					<span class="import-demo-thumb-w import-demo-thumb-classicinfo" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="http://anomica.themetechmount.net/header-classic-info/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-classicinfo.png" alt="ClassicInfo">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
					<!-- rtl -->
					<span class="import-demo-thumb-w import-demo-thumb-rtl" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="http://anomica.themetechmount.net/anomica-rtl/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-rtl.png" alt="RTL">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
						<!-- Landing -->
					<span class="import-demo-thumb-w import-demo-thumb-landing" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="http://anomica.themetechmount.net/anomica-landing/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-landing.png" alt="landing">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
					<!-- classic -->
					<span class="import-demo-thumb-w import-demo-thumb-classic-elementor" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>						
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-classic.png" alt="Classic">
							<span class="tm-import-demo-link-text">View demo online</span>
					</span>
					
					<!-- overlay-elementor -->
					<span class="import-demo-thumb-w import-demo-thumb-overlay-elementor" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="https://www.themetechmount.com/wordpress/anomica/elementor" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-overlay.png" alt="Overlay-elementor">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
					<!-- Infostack -->
					<span class="import-demo-thumb-w import-demo-thumb-infostack-elementor" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="https://www.themetechmount.com/wordpress/anomica/elementor/header-infostack/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-infostack.png" alt="Infostack-elementor">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					

					<!-- ClassicInfo -->
					<span class="import-demo-thumb-w import-demo-thumb-classicinfo-elementor" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="https://www.themetechmount.com/wordpress/anomica/elementor/header-classic-info/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-classicinfo.png" alt="ClassicInfo-Elementor">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
					<!-- demo2 -->
					<span class="import-demo-thumb-w import-demo-thumb-demo2" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="https://www.themetechmount.com/wordpress/anomica/demo2/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-demo2.png" alt="demo2-Elementor">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
					<!-- advanced -->
					<span class="import-demo-thumb-w import-demo-thumb-advanced" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="https://anomica-demo.preyantechnosys.com/adv/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-advanced.png" alt="demo2-advanced">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
					<!-- advanced -->
					<span class="import-demo-thumb-w import-demo-thumb-onepage-elementor" style="display:none;">
						<div class="tm-import-demo-preview-text">Preview:</div>
						<a href="https://www.themetechmount.com/wordpress/anomica/onepage/" target="_blank">
							<img src="<?php echo plugin_dir_url( __FILE__ ) ?>images/layout-onepage.png" alt="demo2-onepage">
							<span class="tm-import-demo-link-text">View demo online</span>
						</a>
					</span>
					
				</div>
				
				<div class="clear clr"></div>
				
			</div>
		
			
			<br /><br />
			<input type="button" class="button button-primary" id="themetechmount_one_click_demo_content" value="<?php esc_attr_e('I agree, continue demo content setup', 'anomica'); ?>" /> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 
			<a href="#" class="tm-one-click-error-close"><?php esc_attr_e('Cancel', 'anomica' ); ?></a>
		</div>
	
	</div>
	
	<div class="clear"></div>
	
	<?php
}
}