(function($) {
    "use strict";
    /**
Core script to handle the entire theme and core functions
**/
    var archia = function() {
        /* Search Bar ============ */
        var siteUrl = '';
        var screenWidth = $(window).width();
        var menuIcon = function() {
            if ($('#top-menu').length) {
                $('#top-menu li.menu-item-has-children > a').append(' <i class="fa fa-chevron-down"></i>')
            }
        }
        var jsBG = function() {
            //   Background image ------------------
            var a = $(".cthbg");
            a.each(function(a) {
                if ($(this).attr("data-bg")) $(this).css("background-image", "url(" + $(this).data("bg") + ")");
            });
        }
        var homeSearch = function() {
            'use strict';
            /* top search in header on click function */
            var quikSearch = jQuery("#quik-search-btn");
            var quikSearchRemove = jQuery("#quik-search-remove");
            quikSearch.on('click', function() {
                jQuery('.dlab-quik-search').fadeIn(500);
                jQuery('.dlab-quik-search').addClass('On');
            });
            quikSearchRemove.on('click', function() {
                jQuery('.dlab-quik-search').fadeOut(500);
                jQuery('.dlab-quik-search').removeClass('On');
            });
            /* top search in header on click function End*/
        }
        var cartButton = function() {
            $(".item-close").on('click', function() {
                $(this).closest(".cart-item").hide('500');
            });
            $('.cart-btn').unbind().on('click', function() {
                $(".cart-list").slideToggle('slow');
            })
        }
        /* One Page Layout ============ */
        var onePageLayout = function() {
            'use strict';
            var headerHeight = parseInt($('.onepage').css('height'), 10);
            $(".scroll").unbind().on('click', function(event) {
                event.preventDefault();
                if (this.hash !== "") {
                    var hash = this.hash;
                    var seactionPosition = $(hash).offset().top;
                    var headerHeight = parseInt($('.onepage').css('height'), 10);
                    $('body').scrollspy({
                        target: ".navbar",
                        offset: headerHeight + 2
                    });
                    var scrollTopPosition = seactionPosition - (headerHeight);
                    $('html, body').animate({
                        scrollTop: scrollTopPosition
                    }, 800, function() {});
                }
            });
            if (jQuery(".scroll-bar").length > 0) {
                $(".scroll-bar").unbind().on('click', function(event) {
                    event.preventDefault();
                    if (this.hash !== "") {
                        var hash = this.hash;
                        var seactionPosition = $(hash).offset().top;
                        var headerHeight = parseInt($('.onepage').css('height'), 10);
                        $('body').scrollspy({
                            target: ".navbar",
                            offset: headerHeight + 2
                        });
                        var scrollTopPosition = seactionPosition - (headerHeight) + 500;
                        $('html, body').animate({
                            scrollTop: scrollTopPosition
                        }, 800, function() {});
                    }
                });
            }
            $('body').scrollspy({
                target: ".navbar",
                offset: headerHeight + 2
            });
        }
        /* Header Height ============ */
        var handleResizeElement = function() {
            $('.header').css('height', '');
            var headerHeight = $('.header').height();
            $('.header').css('height', headerHeight);
        }
        /* Load File ============ */
        var dzTheme = function() {
            'use strict';
            if (screenWidth <= 991) {
                jQuery('.navbar-nav > li > a, .sub-menu > li > a').unbind().on('click', function(e) {
                    if(jQuery(this).parent().children('.sub-menu').length){
                        e.preventDefault();
                        if (jQuery(this).parent().hasClass('open')) {
                            jQuery(this).parent().removeClass('open');
                        } else {
                            jQuery(this).parent().parent().find('li').removeClass('open');
                            jQuery(this).parent().addClass('open');
                        }
                    }
                });
            }
            jQuery('.full-sidenav .navbar-nav > li > a').next('.sub-menu').slideUp();
            jQuery('.full-sidenav .sub-menu > li > a').next('.sub-menu').slideUp();
            jQuery('.full-sidenav .navbar-nav > li > a, .full-sidenav .sub-menu > li > a').unbind().on('click', function(e) {
                jQuery('.full-sidenav .navbar-nav > li > a').not(this).next('.sub-menu').slideUp();
                jQuery(this).next('.sub-menu').toggle(500);
            });
            jQuery('.menu-icon').on('click', function() {
                jQuery('.menu-close,.full-sidenav').addClass('active');
            });
            jQuery('.menu-close').on('click', function() {
                jQuery('.menu-close,.full-sidenav').removeClass('active');
            });
        }
        /* Magnific Popup ============ */
        var MagnificPopup = function() {
            'use strict';
            if (jQuery('.mfp-gallery-with-owl').length) {
                jQuery('.mfp-gallery-with-owl').magnificPopup({
                    delegate: '.mfp-link',
                    type: 'image',
                    tLoading: 'Loading image #%curr%...',
                    mainClass: 'mfp-img-mobile',
                    gallery: {
                        enabled: true,
                        navigateByImgClick: true,
                        preload: [0, 1] // Will preload 0 - before current, and 1 after the current image
                    },
                    image: {
                        tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
                        titleSrc: function(item) {
                            return item.el.attr('title') + '<small></small>';
                        }
                    }
                });
            }
            /* magnificPopup function */
            if (jQuery('.mfp-gallery').length) {
                jQuery('.mfp-gallery').magnificPopup({
                    delegate: '.mfp-link',
                    type: 'image',
                    tLoading: 'Loading image #%curr%...',
                    mainClass: 'mfp-img-mobile',
                    gallery: {
                        enabled: true,
                        navigateByImgClick: true,
                        preload: [0, 1] // Will preload 0 - before current, and 1 after the current image
                    },
                    image: {
                        tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
                        titleSrc: function(item) {
                            return item.el.attr('title') + '<small></small>';
                        }
                    }
                });
            }
            /* magnificPopup function end */
            /* magnificPopup for paly video function */
            if (jQuery('.mfp-video').length) {
                jQuery('.mfp-video').magnificPopup({
                    type: 'iframe',
                    iframe: {
                        markup: '<div class="mfp-iframe-scaler">' + '<div class="mfp-close"></div>' + '<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>' + '<div class="mfp-title">Some caption</div>' + '</div>'
                    },
                    callbacks: {
                        markupParse: function(template, values, item) {
                            values.title = item.el.attr('title');
                        }
                    }
                });
            }
            /* magnificPopup for paly video function end*/
            if ($('.popup-youtube, .popup-vimeo, .popup-gmaps').length) {
                $('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
                    disableOn: 700,
                    type: 'iframe',
                    mainClass: 'mfp-fade',
                    removalDelay: 160,
                    preloader: false,
                    fixedContentPos: false
                });
            }
        }
        /* Scroll To Top ============ */
        var scrollTop = function() {
            'use strict';
            var scrollTop = jQuery("button.scroltop");
            /* page scroll top on click function */
            scrollTop.on('click', function() {
                jQuery("html, body").animate({
                    scrollTop: 0
                }, 1000);
                return false;
            })
            jQuery(window).on("scroll", function() {
                var scroll = jQuery(window).scrollTop();
                if (scroll > 900) {
                    jQuery("button.scroltop").fadeIn(1000);
                } else {
                    jQuery("button.scroltop").fadeOut(1000);
                }
            });
            /* page scroll top on click function end*/
        }
        /* handle Accordian ============ */
        var handleAccordian = function() {
            /* accodin open close icon change */
            jQuery('#accordion').on('hidden.bs.collapse', function(e) {
                jQuery(e.target).prev('.panel-heading').find("i.indicator").toggleClass('glyphicon-minus glyphicon-plus');
            });
            jQuery('#accordion').on('shown.bs.collapse', function(e) {
                jQuery(e.target).prev('.panel-heading').find("i.indicator").toggleClass('glyphicon-minus glyphicon-plus');
            });
            /* accodin open close icon change end */
        }
        /* handle Placeholder ============ */
        var handlePlaceholder = function() {
            /* input placeholder for ie9 & ie8 & ie7 */
            jQuery.support.placeholder = ('placeholder' in document.createElement('input'));
            /* input placeholder for ie9 & ie8 & ie7 end*/
            /*fix for IE7 and IE8  */
            if (!jQuery.support.placeholder) {
                jQuery("[placeholder]").on('focus', function() {
                    if (jQuery(this).val() == jQuery(this).attr("placeholder")) jQuery(this).val("");
                }).on('blur', function() {
                    if (jQuery(this).val() == "") jQuery(this).val(jQuery(this).attr("placeholder"));
                }).blur();
                jQuery("[placeholder]").parents("form").on('submit', function() {
                    jQuery(this).find('[placeholder]').each(function() {
                        if (jQuery(this).val() == jQuery(this).attr("placeholder")) {
                            jQuery(this).val("");
                        }
                    });
                });
            }
            /*fix for IE7 and IE8 end */
        }
        /* Equal Height ============ */
        var equalHeight = function(container) {
            if (jQuery(container).length == 0) {
                return false
            }
            var currentTallest = 0,
                currentRowStart = 0,
                rowDivs = new Array(),
                $el, topPosition = 0;
            $(container).each(function() {
                $el = $(this);
                $($el).height('auto')
                topPostion = $el.position().top;
                if (currentRowStart != topPostion) {
                    for (currentDiv = 0; currentDiv < rowDivs.length; currentDiv++) {
                        rowDivs[currentDiv].height(currentTallest);
                    }
                    rowDivs.length = 0; // empty the array
                    currentRowStart = topPostion;
                    currentTallest = $el.height();
                    rowDivs.push($el);
                } else {
                    rowDivs.push($el);
                    currentTallest = (currentTallest < $el.height()) ? ($el.height()) : (currentTallest);
                }
                for (currentDiv = 0; currentDiv < rowDivs.length; currentDiv++) {
                    rowDivs[currentDiv].height(currentTallest);
                }
            });
        }
        /* Footer Align ============ */
        var footerAlign = function() {
            'use strict';
            jQuery('.site-footer').css('display', 'block');
            jQuery('.site-footer').css('height', 'auto');
            var footerHeight = jQuery('.site-footer').outerHeight();
            jQuery('.footer-fixed > .page-wraper').css('padding-bottom', footerHeight);
            jQuery('.site-footer').css('height', footerHeight);
        }
        /* File Input ============ */
        var fileInput = function() {
            'use strict';
            /* Input type file jQuery */
            jQuery(document).on('change', '.btn-file :file', function() {
                var input = jQuery(this);
                var numFiles = input.get(0).files ? input.get(0).files.length : 1;
                var label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
                input.trigger('fileselect', [numFiles, label]);
            });
            jQuery('.btn-file :file').on('fileselect', function(event, numFiles, label) {
                input = jQuery(this).parents('.input-group').find(':text');
                var log = numFiles > 10 ? numFiles + ' files selected' : label;
                if (input.length) {
                    input.val(log);
                } else {
                    if (log) alert(log);
                }
            });
            /* Input type file jQuery end*/
        }
        /* Header Fixed ============ */
        var headerFix = function() {
            'use strict';
            /* Main navigation fixed on top  when scroll down function custom */
            jQuery(window).on('scroll', function() {
                if (jQuery('.sticky-header').length > 0) {
                    var menu = jQuery('.sticky-header');
                    if ($(window).scrollTop() > menu.offset().top) {
                        menu.addClass('is-fixed');
                        // $('.header-archia .container > .logo-header .logo').attr('src','images/logo.png');
                    } else {
                        menu.removeClass('is-fixed');
                        // $('.header-archia .container > .logo-header .logo').attr('src','images/logo-white.png')
                    }
                }
            });
            /* Main navigation fixed on top  when scroll down function custom end*/
        }
        /* Masonry Box ============ */
        var masonryBox = function() {
            'use strict';
            /* masonry by  = bootstrap-select.min.js */
            if (jQuery('#masonry, .masonry').length) {
                var self = $("#masonry, .masonry");
                if (jQuery('.card-container').length) {
                    var columnWidthValue = (self.attr('data-column-width') === undefined) ? '' : self.attr('data-column-width');
                    if (columnWidthValue != '') {
                        columnWidthValue = parseInt(columnWidthValue);
                    }
                    self.imagesLoaded(function() {
                        self.masonry({
                            columnWidth: columnWidthValue,
                            gutterWidth: 15,
                            isAnimated: true,
                            itemSelector: ".card-container"
                        });
                    });
                }
            }
            if (jQuery('.filters').length) {
                jQuery(".filters").on('click', 'li', function(e) {
                    e.preventDefault();
                    var filter = $(this).attr("data-filter");
                    self.masonryFilter({
                        filter: function() {
                            if (!filter) return true;
                            //return $(this).attr("data-filter") == filter;
                            return $(this).hasClass(filter);
                        }
                    });
                });
            }
            /* masonry by  = bootstrap-select.min.js end */
        }
        /* Isotope Box ============ */
        var isotopeBox = function() {
            if ($(".folio-isotope").length) {
                $(".folio-isotope").each(function() {
                    var $that = $(this),
                        active_filter = $('.folio-filters .folio-filter:first-child').attr("data-filter");
                    $that.isotope({
                        itemSelector: ".folio-item, .folio-item-two, .folio-item-three, .folio-item-full",
                        percentPosition: true,
                        masonry: {
                            // use outer width of grid-sizer for columnWidth
                            columnWidth: ".grid-sizer",
                        },
                        transformsEnabled: true,
                        transitionDuration: "700ms",
                        filter: active_filter
                    });
                    $that.imagesLoaded(function() {
                        $that.isotope("layout");
                    });
                    $(".folio-filters").on("click", ".folio-filter", function(b) {
                        b.preventDefault();
                        var c = $(this).attr("data-filter"),
                            d = $(this).text();
                        $that.isotope({
                            filter: c
                        });
                        $(".folio-filters .folio-filter").removeClass("focus active filactiv");
                        $(this).addClass("focus filactiv");
                    });
                    // $that.isotope("on", "layoutComplete", function(a, b) {
                    //     initFolioGallery();
                    // });
                    // $that.on( 'arrangeComplete', function( event, filteredItems ) {
                    //     initFolioGallery();
                    // } );
                });
            }
        }
        var swiperSlider = function() {
            var mySwiper = new Swiper(".swiper-container", {
                direction: "vertical",
                loop: true,
                pagination: {
                    el: '.swiper-pagination',
                    type: 'bullets',
                    clickable: true,
                },
                grabCursor: true,
                speed: 1000,
                parallax: true,
                autoplay: false,
                effect: "slide",
                mousewheel: true
            });
        }
        /* Set Div Height ============ */
        var setDivHeight = function() {
            'use strict';
            var allHeights = [];
            jQuery('.dzseth > div, .dzseth .img-cover, .dzseth .seth').each(function(e) {
                allHeights.push(jQuery(this).height());
            })
            jQuery('.dzseth > div, .dzseth .img-cover, .dzseth .seth').each(function(e) {
                var maxHeight = Math.max.apply(Math, allHeights);
                jQuery(this).css('height', maxHeight);
            })
            allHeights = [];
            /* Removice */
            //var screenWidth = $( window ).width();
            if (screenWidth < 991) {
                jQuery('.dzseth > div, .dzseth .img-cover, .dzseth .seth').each(function(e) {
                    jQuery(this).css('height', '');
                })
            }
        }
        /* Counter Number ============ */
        var counter = function() {
            if (jQuery('.counter').length) {
                jQuery('.counter').counterUp({
                    delay: 10,
                    time: 3000
                });
            }
        }
        /* Video Popup ============ */
        var handleVideo = function() {
            /* Video responsive function */
            jQuery('iframe[src*="youtube.com"]').wrap('<div class="embed-responsive embed-responsive-16by9"></div>');
            jQuery('iframe[src*="vimeo.com"]').wrap('<div class="embed-responsive embed-responsive-16by9"></div>');
            /* Video responsive function end */
        }
        /* Gallery Filter ============ */
        var handleFilterMasonary = function() {
            /* gallery filter activation = jquery.mixitup.min.js */
            if (jQuery('#image-gallery-mix').length) {
                jQuery('.gallery-filter').find('li').each(function() {
                    $(this).addClass('filter');
                });
                jQuery('#image-gallery-mix').mixItUp();
            };
            if (jQuery('.gallery-filter.masonary').length) {
                jQuery('.gallery-filter.masonary').on('click', 'span', function() {
                    var selector = $(this).parent().attr('data-filter');
                    jQuery('.gallery-filter.masonary span').parent().removeClass('active');
                    jQuery(this).parent().addClass('active');
                    jQuery('#image-gallery-isotope').isotope({
                        filter: selector
                    });
                    return false;
                });
            }
            /* gallery filter activation = jquery.mixitup.min.js */
        }
        /* handle Bootstrap Select ============ */
        var handleBootstrapSelect = function() {
            /* Bootstrap Select box function by  = bootstrap-select.min.js */
            if (jQuery('select').length) {
                jQuery('select').selectpicker();
            }
            /* Bootstrap Select box function by  = bootstrap-select.min.js end*/
        }
        /* handle Bootstrap Touch Spin ============ */
        var handleBootstrapTouchSpin = function() {
            if (jQuery("input[name='demo_vertical2']").length) {
                jQuery("input[name='demo_vertical2']").TouchSpin({
                    verticalbuttons: true,
                    verticalupclass: 'ti-plus',
                    verticaldownclass: 'ti-minus'
                });
            }
        }
        /* Resizebanner ============ */
        var handleBannerResize = function() {
            $(".full-height").css("height", $(window).height());
        }
        /* Countdown ============ */
        var handleCountDown = function(WebsiteLaunchDate) {
            /* Time Countr Down Js */
            if ($(".countdown").length) {
                $('.countdown').countdown({
                    date: WebsiteLaunchDate + ' 23:5'
                }, function() {
                    $('.countdown').text('we are live');
                });
            }
            /* Time Countr Down Js End */
        }
        /* Content Scroll ============ */
        var handleCustomScroll = function() {
            /* all available option parameters with their default values */
            if ($(".content-scroll").length) {
                $(".content-scroll").mCustomScrollbar({
                    setWidth: false,
                    setHeight: false,
                    axis: "y"
                });
            }
        }
        /* WOW ANIMATION ============ */
        var wow_animation = function() {
            if ($('.wow').length > 0) {
                var wow = new WOW({
                    boxClass: 'wow', // animated element css class (default is wow)
                    animateClass: 'animated', // animation css class (default is animated)
                    offset: 50, // distance to the element when triggering the animation (default is 0)
                    mobile: false // trigger animations on mobile devices (true is default)
                });
                wow.init();
            }
        }
        /* Left Menu ============ */
        var handleSideBarMenu = function() {
            $('.openbtn').on('click', function(e) {
                e.preventDefault();
                if ($('#mySidenav').length > 0) {
                    document.getElementById("mySidenav").style.left = "0";
                }
                if ($('#mySidenav1').length > 0) {
                    document.getElementById("mySidenav1").style.right = "0";
                }
            })
            $('.closebtn').on('click', function(e) {
                e.preventDefault();
                if ($('#mySidenav').length > 0) {
                    document.getElementById("mySidenav").style.left = "-300px";
                }
                if ($('#mySidenav1').length > 0) {
                    document.getElementById("mySidenav1").style.right = "-820px";
                }
            })
        }
        /* Left Menu ============ */
        var handleMenuPosition = function() {
            $(".header-nav li").unbind().each(function(e) {
                if ($('ul', this).length) {
                    var elm = $('ul:first', this);
                    var off = elm.offset();
                    var l = off.left;
                    var w = elm.width();
                    var docH = $("body").height();
                    var docW = $("body").width();
                    var isEntirelyVisible = (l + w <= docW);
                    if (!isEntirelyVisible) {
                        $(this).find('.sub-menu:first').addClass('left');
                    } else {
                        $(this).find('.sub-menu:first').removeClass('left');
                    }
                }
            });
        }
        /* Range ============ */
        var priceslider = function() {
            if ($(".price-slide, .price-slide-2").length > 0) {
                $("#slider-range,#slider-range-2").slider({
                    range: true,
                    min: 300,
                    max: 4000,
                    values: [0, 5000],
                    slide: function(event, ui) {
                        var min = ui.values[0],
                            max = ui.values[1];
                        $('#' + this.id).prev().val("$" + min + " - $" + max);
                    }
                });
            }
        }
        /* BGEFFECT ============ */
        var handleBGElements = function() {
            if (screenWidth > 1023) {
                if (jQuery('.bgeffect').length) {
                    var s = skrollr.init({
                        edgeStrategy: 'set',
                        easing: {
                            WTF: Math.random,
                            inverted: function(p) {
                                return 1 - p;
                            }
                        }
                    });
                }
            }
        }
        var boxHover = function() {
            jQuery('.box-hover').on('mouseenter', function() {
                jQuery('.box-hover').removeClass('active');
                jQuery(this).addClass('active');
            })
        }
        var reposition = function() {
            'use strict';
            var modal = jQuery(this),
                dialog = modal.find('.modal-dialog');
            modal.css('display', 'block');
            /* Dividing by two centers the modal exactly, but dividing by three 
             or four works better for larger screens.  */
            dialog.css("margin-top", Math.max(0, (jQuery(window).height() - dialog.height()) / 2));
        }
        var handleResize = function() {
            /* Reposition when the window is resized */
            jQuery(window).on('resize', function() {
                jQuery('.modal:visible').each(reposition);
                equalHeight('.equal-wraper .equal-col');
                footerAlign();
            });
        }
        var handlePlaceholderAnimation = function() {
            if (jQuery('.dezPlaceAni').length) {
                $('.dezPlaceAni input, .dezPlaceAni textarea').on('focus', function() {
                    $(this).parents('.form-group, .news-box').addClass('focused');
                });
                $('.dezPlaceAni input, .dezPlaceAni textarea').on('blur', function() {
                    var inputValue = $(this).val();
                    if (inputValue == "") {
                        $(this).removeClass('filled');
                        $(this).parents('.form-group, .news-box').removeClass('focused');
                    } else {
                        $(this).addClass('filled');
                    }
                })
            }
        }
        var btnAware = function() {
            $('.btn-aware').on('mouseenter', function(e) {
                var parentOffset = $(this).offset(),
                    relX = e.pageX - parentOffset.left,
                    relY = e.pageY - parentOffset.top;
                $(this).find('span').css({
                    top: relY,
                    left: relX
                })
            }).on('mouseout', function(e) {
                var parentOffset = $(this).offset(),
                    relX = e.pageX - parentOffset.left,
                    relY = e.pageY - parentOffset.top;
                $(this).find('span').css({
                    top: relY,
                    left: relX
                })
            });
        }
        var heartBlast = function() {
            $(".heart").on("click", function() {
                $(this).toggleClass("heart-blast");
            });
        }
        /* Website Launch Date */
        var WebsiteLaunchDate = new Date();
        var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        WebsiteLaunchDate.setMonth(WebsiteLaunchDate.getMonth() + 1);
        WebsiteLaunchDate = WebsiteLaunchDate.getDate() + " " + monthNames[WebsiteLaunchDate.getMonth()] + " " + WebsiteLaunchDate.getFullYear();
        /* Website Launch Date END */
        /* Function ============ */
        return {
            init: function() {
                menuIcon();
                jsBG();
                boxHover();
                wow_animation();
                priceslider();
                dzTheme();
                handleResizeElement();
                homeSearch();
                MagnificPopup();
                handleAccordian();
                scrollTop();
                handlePlaceholder();
                handlePlaceholderAnimation();
                fileInput();
                headerFix();
                setDivHeight();
                handleVideo();
                // handleFilterMasonary();
                handleCountDown(WebsiteLaunchDate);
                handleCustomScroll();
                handleSideBarMenu();
                cartButton();
                handleBannerResize();
                handleResize();
                heartBlast();
                btnAware();
                jQuery('.modal').on('show.bs.modal', reposition);
                $('[data-toggle="tooltip"]').tooltip()
            },
            load: function() {
                handleBGElements();
                handleBootstrapSelect();
                handleBootstrapTouchSpin();
                equalHeight('.equal-wraper .equal-col');
                counter();
                handleMenuPosition();
                // masonryBox();
                isotopeBox();
                swiperSlider();
            },
            resize: function() {
                screenWidth = $(window).width();
                dzTheme();
                handleResizeElement();
                handleSideBarMenu();
                handleMenuPosition();
                setDivHeight();
            }
        }
    }();
    /* Document.ready Start */
    jQuery(document).ready(function() {
        archia.init();
        jQuery('.navicon').on('click', function() {
            $(this).toggleClass('open');
        });
        $('a[data-toggle="tab"]').on('click', function() {
            // todo remove snippet on bootstrap v4
            $('a[data-toggle="tab"]').on('click', function() {
                $($(this).attr('href')).show().addClass('show active').siblings().hide();
            })
        });
    });
    /* Document.ready END */
    /* Window Load START */
    $(window).on("load", function(e) {
        archia.load();
        if($('#loading-area').length){
            setTimeout(function() {
                $('#loading-area').remove();
            }, 0);
        }
            
    });
    /*  Window Load END */
    /* Window Resize START */
    jQuery(window).on('resize', function() {
        'use strict';
        archia.resize();
    });
    /*  Window Resize END */
    $(document).ready(function() {
        /* 1. Visualizing things on Hover - See next part for action on click */
        $('#stars li').on('mouseover', function() {
            var onStar = parseInt($(this).data('value'), 10); // The star currently mouse on
            // Now highlight all the stars that's not after the current hovered star
            $(this).parent().children('li.star').each(function(e) {
                if (e < onStar) {
                    $(this).addClass('hover');
                } else {
                    $(this).removeClass('hover');
                }
            });
        }).on('mouseout', function() {
            $(this).parent().children('li.star').each(function(e) {
                $(this).removeClass('hover');
            });
        });
        /* 2. Action to perform on click */
        $('#stars li').on('click', function() {
            var onStar = parseInt($(this).data('value'), 10); // The star currently selected
            var stars = $(this).parent().children('li.star');
            for (i = 0; i < stars.length; i++) {
                $(stars[i]).removeClass('selected');
            }
            for (i = 0; i < onStar; i++) {
                $(stars[i]).addClass('selected');
            }
            // JUST RESPONSE (Not needed)
            var ratingValue = parseInt($('#stars li.selected').last().data('value'), 10);
            var msg = "";
            if (ratingValue > 1) {
                msg = "Thanks! You rated this " + ratingValue + " stars.";
            } else {
                msg = "We will improve ourselves. You rated this " + ratingValue + " stars.";
            }
            responseMessage(msg);
        });
    });

    function responseMessage(msg) {
        alert(msg);
    }
    /* google map 3 */
    if (jQuery('#map3').length) {
        function myMap3() {
            var mapCanvas = document.getElementById("map3");
            var mapOptions = {
                center: new google.maps.LatLng(45.434046, 12.340284),
                zoom: 11,
                mapTypeId: google.maps.MapTypeId.TERRAIN,
                styles: [{
                    "featureType": "all",
                    "elementType": "all",
                    "stylers": [{
                        "saturation": "32"
                    }, {
                        "lightness": "-3"
                    }, {
                        "visibility": "on"
                    }, {
                        "weight": "1.18"
                    }]
                }, {
                    "featureType": "administrative",
                    "elementType": "labels",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "landscape",
                    "elementType": "labels",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "landscape.man_made",
                    "elementType": "all",
                    "stylers": [{
                        "saturation": "-70"
                    }, {
                        "lightness": "14"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "labels",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "labels",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "transit",
                    "elementType": "labels",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "all",
                    "stylers": [{
                        "saturation": "100"
                    }, {
                        "lightness": "-14"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "labels",
                    "stylers": [{
                        "visibility": "off"
                    }, {
                        "lightness": "12"
                    }]
                }]
            };
            var map = new google.maps.Map(mapCanvas, mapOptions);
        }
        google.maps.event.addDomListener(window, 'load', myMap3);
    }
})(jQuery);
(function($) {
    "use strict";
    /* JavaScript Document */
    jQuery(document).ready(function() {
        'use strict';
        /* image-carousel function by = owl.carousel.js */
        jQuery('.trending-stories').owlCarousel({
            loop: true,
            center: true,
            margin: 40,
            nav: true,
            dots: false,
            navText: ['<i class="la la-long-arrow-left"></i>', '<i class="la la-long-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                },
                480: {
                    items: 2,
                    margin: 20
                },
                1024: {
                    items: 3
                },
                1200: {
                    items: 3
                },
                1400: {
                    items: 3
                }
            }
        })
        /* image-carousel function by = owl.carousel.js */
        jQuery('.project-carousel').owlCarousel({
            loop: true,
            center: true,
            margin: 30,
            nav: true,
            dots: false,
            navText: ['<i class="la la-long-arrow-left"></i>', '<i class="la la-long-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                },
                480: {
                    items: 2,
                    margin: 20
                },
                1024: {
                    items: 3
                },
                1200: {
                    items: 2
                },
                1400: {
                    items: 2
                }
            }
        })
        /* image-carousel function by = owl.carousel.js */
        jQuery('.header-blog-carousel').owlCarousel({
            loop: true,
            margin: 30,
            nav: true,
            dots: false,
            navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                    margin: 10,
                    center: true,
                    stagePadding: 30
                },
                480: {
                    items: 1,
                    margin: 10,
                    center: true,
                    stagePadding: 30
                },
                1024: {
                    items: 3
                },
                1200: {
                    items: 4
                },
                1400: {
                    items: 4
                }
            }
        })
        /*  Blog post Carousel function by = owl.carousel.js */
        jQuery('.blog-carousel').owlCarousel({
            loop: true,
            autoplay: true,
            margin: 30,
            nav: true,
            dots: false,
            navText: ['<i class="flaticon-left-arrow"></i>', '<i class="flaticon-right-arrow"></i>'],
            responsive: {
                0: {
                    items: 1
                },
                480: {
                    items: 2
                },
                991: {
                    items: 2
                },
                1000: {
                    items: 3
                }
            }
        })
        /*  Blog post Carousel function by = owl.carousel.js */
        jQuery('.team-carousel').owlCarousel({
            loop: true,
            autoplay: true,
            margin: 100,
            nav: true,
            stagePadding: 100,
            autoplaySpeed: 1000,
            navSpeed: 1000,
            paginationSpeed: 1000,
            slideSpeed: 1000,
            dots: false,
            navText: ['<i class="la la-long-arrow-left"></i> <span>Prev</span>', '<span>Next</span><i class="la la-long-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                    stagePadding: 0
                },
                480: {
                    items: 1
                },
                991: {
                    items: 1
                },
                1000: {
                    items: 1
                }
            }
        })
        /*  Blog post Carousel function by = owl.carousel.js */
        jQuery('.post-slide1').owlCarousel({
            loop: true,
            autoplay: true,
            margin: 40,
            center: true,
            nav: true,
            autoplaySpeed: 1000,
            navSpeed: 1000,
            paginationSpeed: 1000,
            slideSpeed: 1000,
            dots: false,
            navText: ['<i class="la la-long-arrow-left"></i>', '<i class="la la-long-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                    stagePadding: 15,
                },
                480: {
                    items: 1,
                    stagePadding: 15
                },
                991: {
                    items: 1
                },
                1000: {
                    items: 1.5,
                }
            }
        })
        /*  Blog post Carousel function by = owl.carousel.js */
        jQuery('.post-slide2').owlCarousel({
            loop: true,
            autoplay: true,
            margin: 40,
            center: true,
            stagePadding: 40,
            nav: true,
            autoplaySpeed: 1000,
            navSpeed: 1000,
            paginationSpeed: 1000,
            slideSpeed: 1000,
            dots: false,
            navText: ['<i class="la la-long-arrow-left"></i>', '<i class="la la-long-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                    stagePadding: 15
                },
                480: {
                    items: 1
                },
                991: {
                    items: 2
                },
                1000: {
                    items: 3,
                }
            }
        })
        /* testimonial two function by = owl.carousel.js */
        jQuery('.testimonial-two-dots-bx').owlCarousel({
            loop: true,
            autoplay: false,
            margin: 10,
            nav: true,
            dots: true,
            navText: ['<i class="flaticon-left-arrow"></i>', '<i class="flaticon-right-arrow"></i>'],
            responsive: {
                0: {
                    items: 1
                },
                480: {
                    items: 1
                },
                991: {
                    items: 1
                },
                1000: {
                    items: 1
                }
            }
        })
        /* testimonial two function by = owl.carousel.js */
        jQuery('.testimonial-two').owlCarousel({
            loop: true,
            autoplay: false,
            margin: 30,
            nav: true,
            dots: true,
            navText: ['<i class="flaticon-left-arrow"></i>', '<i class="flaticon-right-arrow"></i>'],
            responsive: {
                0: {
                    items: 1
                },
                480: {
                    items: 1
                },
                991: {
                    items: 2
                },
                1000: {
                    items: 2
                }
            }
        })
        /* testimonial two function by = owl.carousel.js */
        jQuery('.project-carousel-2').owlCarousel({
            loop: true,
            autoplay: true,
            right: true,
            margin: 30,
            nav: true,
            dots: true,
            navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                    stagePadding: 60,
                    margin: 15
                },
                480: {
                    items: 1,
                    margin: 15,
                    stagePadding: 60
                },
                768: {
                    items: 1
                },
                1000: {
                    items: 1.5
                }
            }
        })
        /* testimonial two function by = owl.carousel.js */
        jQuery('.exhibition-carousel').owlCarousel({
            loop: true,
            autoplay: true,
            right: true,
            margin: 0,
            nav: true,
            dots: true,
            navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
            responsive: {
                0: {
                    items: 1
                },
                480: {
                    items: 1
                },
                991: {
                    items: 1
                },
                1000: {
                    items: 1
                }
            }
        })
        /* testimonial two function by = owl.carousel.js */
        jQuery('.project-carousel-1').owlCarousel({
            loop: true,
            autoplay: true,
            right: true,
            margin: 0,
            nav: true,
            autoplaySpeed: 1000,
            navSpeed: 1000,
            paginationSpeed: 1000,
            slideSpeed: 1000,
            dots: true,
            navText: ['<i class="la la-arrow-left"></i> Prev', 'Next <i class="la la-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1
                },
                480: {
                    items: 1
                },
                991: {
                    items: 1
                },
                1000: {
                    items: 1
                }
            }
        })
        /*  Blog post Carousel function by = owl.carousel.js */
        jQuery('.client-logo').owlCarousel({
            loop: true,
            autoplay: true,
            margin: 20,
            nav: true,
            autoplaySpeed: 1000,
            navSpeed: 1000,
            paginationSpeed: 1000,
            slideSpeed: 1000,
            dots: false,
            navText: ['<i class="la la-long-arrow-left"></i>', '<i class="la la-long-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 2
                },
                480: {
                    items: 4
                },
                991: {
                    items: 5
                },
                1000: {
                    items: 6
                }
            }
        })
        /* image-carousel function by = owl.carousel.js */
        jQuery('.footer-gallery').owlCarousel({
            loop: true,
            margin: 0,
            nav: true,
            dots: false,
            navText: ['<i class="la la-long-arrow-left"></i>', '<i class="la la-long-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                    center: true,
                    stagePadding: 30
                },
                480: {
                    items: 2,
                },
                1024: {
                    items: 3
                },
                1200: {
                    items: 4
                },
                1400: {
                    items: 4
                }
            }
        })
        /* image-carousel function by = owl.carousel.js */
        jQuery('.related-post').owlCarousel({
            loop: true,
            margin: 30,
            nav: true,
            dots: false,
            navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                },
                480: {
                    items: 2,
                },
                1024: {
                    items: 2
                },
                1200: {
                    items: 2
                }
            }
        })
        /* image-carousel function by = owl.carousel.js */
        jQuery('.portfolio-carousel').owlCarousel({
            loop: true,
            margin: 0,
            nav: true,
            dots: false,
            autoplaySpeed: 1000,
            navSpeed: 1000,
            paginationSpeed: 1000,
            slideSpeed: 1000,
            dots: true,
            navText: ['<i class="la la-arrow-left"></i> Prev', 'Next <i class="la la-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                },
                480: {
                    items: 2,
                },
                1024: {
                    items: 3
                },
                1200: {
                    items: 4
                }
            }
        })
        /* image-carousel function by = owl.carousel.js */
        jQuery('.portfolio-carousel-2').owlCarousel({
            loop: true,
            margin: 0,
            nav: true,
            autoWidth: true,
            dots: false,
            dots: true,
            navText: ['<i class="la la-arrow-left"></i> Prev', 'Next <i class="la la-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                },
                480: {
                    items: 2,
                },
                1024: {
                    items: 3
                },
                1200: {
                    items: 4
                }
            }
        })
        jQuery('.portfolio-carousel-2').on('mousewheel', '.owl-stage', function(e) {
            if (e.deltaY > 0) {
                jQuery('.portfolio-carousel-2').trigger('next.owl', [2000]);
            } else {
                jQuery('.portfolio-carousel-2').trigger('prev.owl', [2000]);
            }
            e.preventDefault();
        });
        /* image-carousel no margin function by = owl.carousel.js */
        jQuery('.team-slider').owlCarousel({
            loop: true,
            autoplay: false,
            margin: 30,
            nav: false,
            dots: true,
            navText: ['<i class="flaticon-left-arrow"></i>', '<i class="flaticon-right-arrow"></i>'],
            responsive: {
                0: {
                    items: 1
                },
                480: {
                    items: 2
                },
                1024: {
                    items: 2
                },
                1200: {
                    items: 2
                }
            }
        })
        /* image-carousel function by = owl.carousel.js */
        jQuery('.project-area-info').owlCarousel({
            loop: true,
            margin: 30,
            nav: true,
            dots: false,
            navText: ['<i class="la la-angle-left"></i>', '<i class="la la-angle-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                },
                480: {
                    items: 1,
                },
                1024: {
                    items: 1
                },
                1200: {
                    items: 1
                }
            }
        })
        /* image-carousel function by = owl.carousel.js */
        jQuery('.client-box-full').owlCarousel({
            loop: true,
            margin: 30,
            nav: true,
            dots: false,
            navText: ['<i class="la la-arrow-left"></i>', '<i class="la la-arrow-right"></i>'],
            responsive: {
                0: {
                    items: 1,
                },
                480: {
                    items: 1,
                },
                1024: {
                    items: 1
                },
                1200: {
                    items: 1
                }
            }
        })
    });
    /* Document .ready END */
})(jQuery);

