<?php
/**
 * @package Archia - Architecture & Interior WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 20-05-2019
 * @since 1.0.0
 * @version 1.0.0
 * @copyright Copyright ( C ) 2014 - 2019 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */
// Your php code goes here
function archia_child_enqueue_styles() {
    $parent_style = 'archia-style'; // This is 'archia-style' for the Anakual theme.
    wp_enqueue_style( 
        $parent_style, 
        get_template_directory_uri() . '/style.css', 
        array(
            'archia-fonts', 
            'font-awesome', 
            'line-awesome', 
            'magnific-popup', 
            'swiper',
            'animate',
            'bootstrap-select',
            'bootstrap',
            'owl-carousel',
            'scrollbar',
        ), 
        null 
    );
    wp_enqueue_style( 'archia-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style, 'archia-template' , 'archia-color'),
        wp_get_theme()->get('Version')
    );
}
add_action( 'wp_enqueue_scripts', 'archia_child_enqueue_styles' );